/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.runtime.ang.introspector.extension;

import static org.mule.runtime.deployment.model.api.artifact.ArtifactDescriptorFactoryProvider.artifactDescriptorFactoryProvider;
import static org.mule.runtime.deployment.model.api.builder.DeployableArtifactClassLoaderFactoryProvider.regionPluginClassLoadersFactory;
import static org.mule.runtime.globalconfig.api.maven.MavenClientFactory.setMavenClientProvider;

import org.mule.maven.client.api.LocalRepositorySupplierFactory;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.PomFileSupplierFactory;
import org.mule.maven.client.api.SettingsSupplierFactory;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.artifact.DescriptorLoaderRepositoryFactory;
import org.mule.runtime.deployment.model.api.builder.RegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.api.plugin.resolver.PluginDependenciesResolver;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;

import com.mulesoft.runtime.ang.introspector.extension.application.ApplicationClassLoaderFactory;

/**
 * Mule resources registry that has implementations for factories and utilities for creating artifacts.
 */
public class MuleArtifactResourcesRegistry {

  private final ModuleRepository moduleRepository;

  private PluginDependenciesResolver pluginDependenciesResolver;

  private final ArtifactClassLoader containerArtifactClassLoader;

  private ArtifactDescriptorFactory<ApplicationDescriptor> applicationDescriptorFactory;

  private ApplicationClassLoaderFactory applicationClassLoaderFactory;

  /**
   * Creates an instance of the registry.
   */
  public MuleArtifactResourcesRegistry(ModuleRepository moduleRepository,
                                       ArtifactClassLoader containerArtifactClassLoader) {
    this.moduleRepository = moduleRepository;
    this.containerArtifactClassLoader = containerArtifactClassLoader;

    // Force all artifact resolution from the contents of the heavyweight artifact, do not connect to an external Maven
    // repository.
    setMavenClientProvider(() -> new MavenClientProvider() {

      @Override
      public MavenClient createMavenClient(MavenConfiguration mavenConfiguration) {
        return null;
      }

      @Override
      public PomFileSupplierFactory getPomFileSuppliers() {
        return null;
      }

      @Override
      public LocalRepositorySupplierFactory getLocalRepositorySuppliers() {
        return null;
      }

      @Override
      public SettingsSupplierFactory getSettingsSupplierFactory() {
        return null;
      }
    });

    init();
  }

  private void init() {
    DescriptorLoaderRepository descriptorLoaderRepository =
        new DescriptorLoaderRepositoryFactory().createDescriptorLoaderRepository();

    // We need to ensure the dependency on the runtime extModels is upgraded on every new minor release of the runtime to allow
    // introspection of applications with new versions as minRuntimeVersion.
    ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder = ArtifactDescriptorValidatorBuilder.builder()
        .validateMinMuleVersionUsingSemanticVersion();

    ArtifactDescriptorFactory<ArtifactPluginDescriptor> artifactPluginDescriptorFactory = artifactDescriptorFactoryProvider()
        .createArtifactPluginDescriptorFactory(descriptorLoaderRepository, artifactDescriptorValidatorBuilder);

    applicationDescriptorFactory = artifactDescriptorFactoryProvider()
        .createApplicationDescriptorFactory(artifactPluginDescriptorFactory, descriptorLoaderRepository,
                                            artifactDescriptorValidatorBuilder);

    pluginDependenciesResolver =
        artifactDescriptorFactoryProvider().createBundlePluginDependenciesResolver(artifactPluginDescriptorFactory);

    RegionPluginClassLoadersFactory regionPluginClassLoadersFactory = regionPluginClassLoadersFactory(moduleRepository);
    applicationClassLoaderFactory =
        new ApplicationClassLoaderFactory(containerArtifactClassLoader, regionPluginClassLoadersFactory,
                                          pluginDependenciesResolver);
  }

  public ArtifactClassLoader getContainerArtifactClassLoader() {
    return containerArtifactClassLoader;
  }

  public ArtifactDescriptorFactory<ApplicationDescriptor> getApplicationDescriptorFactory() {
    return applicationDescriptorFactory;
  }

  public PluginDependenciesResolver getPluginDependenciesResolver() {
    return pluginDependenciesResolver;
  }

  public ApplicationClassLoaderFactory getApplicationClassLoaderFactory() {
    return applicationClassLoaderFactory;
  }

}
