/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.apikit.steps;

import com.google.common.base.Strings;
import com.mulesoft.tools.migration.library.apikit.steps.AbstractApikitMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ApikitHttpListenerMapping
extends AbstractApikitMigrationStep {
    private static final String XPATH_SELECTOR = "//*[local-name()='router' and namespace-uri()='http://www.mulesoft.org/schema/mule/mule-apikit']";
    private static final String HTTP_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/http";
    private static final Namespace HTTP_NAMESPACE = Namespace.getNamespace((String)"http://www.mulesoft.org/schema/mule/http");
    private static final String STATUS_CODE_ATTR_NAME = "statusCode";

    public String getDescription() {
        return "Update APIkit Http Listener Mappings";
    }

    public ApikitHttpListenerMapping() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        Element flow = ApikitHttpListenerMapping.getParentFlow(element);
        if (flow != null) {
            Element httpListener = ApikitHttpListenerMapping.getHttpListener(flow);
            this.migrateResponse(httpListener.getChild("response", HTTP_NAMESPACE));
            this.migrateErrorResponse(httpListener.getChild("error-response", HTTP_NAMESPACE));
        }
    }

    private void migrateResponse(Element response) {
        this.migrateResponse(response, "200");
    }

    private void migrateErrorResponse(Element response) {
        this.migrateResponse(response, "500");
        Element body = response.getChild("body", response.getNamespace());
        if (body == null) {
            Element newBody = new Element("body", response.getNamespace());
            newBody.setText(ApikitHttpListenerMapping.buildExpression("payload"));
            response.addContent(0, (Content)newBody);
        }
    }

    private void migrateResponse(Element response, String defaultStatusCode) {
        Attribute statusCode = response.getAttribute(STATUS_CODE_ATTR_NAME);
        if (statusCode != null) {
            String currentValue = ApikitHttpListenerMapping.getExpressionValue(statusCode.getValue());
            String newValue = "vars.httpStatus default " + (Strings.isNullOrEmpty((String)currentValue) ? defaultStatusCode : currentValue);
            response.setAttribute(STATUS_CODE_ATTR_NAME, ApikitHttpListenerMapping.buildExpression(newValue));
        } else {
            response.setAttribute(STATUS_CODE_ATTR_NAME, ApikitHttpListenerMapping.buildExpression("vars.httpStatus default " + defaultStatusCode));
        }
        Element header = response.getChild("headers", HTTP_NAMESPACE);
        if (header != null) {
            String headerValue = ApikitHttpListenerMapping.getExpressionValue(header.getValue());
            String newHeaderValue = "vars.outboundHeaders default {}" + (Strings.isNullOrEmpty((String)headerValue) ? "" : " ++ " + headerValue);
            header.setText(ApikitHttpListenerMapping.buildExpression(newHeaderValue));
        } else {
            Element newHeader = new Element("headers", HTTP_NAMESPACE);
            newHeader.setText(ApikitHttpListenerMapping.buildExpression("vars.outboundHeaders default {}"));
            response.addContent((Content)newHeader);
        }
    }

    private static boolean isHttpListener(Element element) {
        return HTTP_NAMESPACE.equals((Object)element.getNamespace()) && "listener".equalsIgnoreCase(element.getName());
    }

    public static Element getHttpListener(Element flow) {
        return flow.getChildren().stream().filter(ApikitHttpListenerMapping::isHttpListener).findFirst().orElse(null);
    }

    private static Element getParentFlow(Element element) {
        if (XmlDslUtils.isTopLevelElement((Element)element)) {
            return null;
        }
        Element parent = element.getParentElement();
        if ("flow".equalsIgnoreCase(parent.getName())) {
            return parent;
        }
        return ApikitHttpListenerMapping.getParentFlow(element);
    }

    private static String getExpressionValue(String str) {
        return str.replaceAll("#", "").replaceAll("\\[", "").replaceAll("]", "").trim();
    }

    private static String buildExpression(String value) {
        return "#[" + value + "]";
    }
}

