/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.gateway.steps.policy;

import com.mulesoft.tools.migration.library.gateway.steps.GatewayMigrationStep;
import com.mulesoft.tools.migration.library.gateway.steps.GatewayNamespaces;
import com.mulesoft.tools.migration.project.model.pom.PomModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class PolicyMigrationStep
extends GatewayMigrationStep {
    protected static final String MULE_4_TAG_NAME = "mule";
    protected static final String POLICY_NAME = "policyName";
    protected static final String ID = "id";
    private static final String PROXY_TAG_NAME = "proxy";
    private static final String SOURCE_TAG_NAME = "source";
    protected static final String EXECUTE_NEXT_TAG_NAME = "execute-next";
    protected static final String TRY_TAG_NAME = "try";
    protected static final String ERROR_HANDLER_TAG_NAME = "error-handler";
    protected static final String CONFIG_REF_ATTR_NAME = "config-ref";
    protected static final String VALUE_ATTR_NAME = "value";
    private static final String HTTP_POLICY_XSI_URI = "http://www.mulesoft.org/schema/mule/http-policy http://www.mulesoft.org/schema/mule/http-policy/current/mule-http-policy.xsd";

    public PolicyMigrationStep(Namespace namespace, String tagName) {
        super(namespace, tagName);
    }

    public PolicyMigrationStep() {
    }

    private String getPolicyName(Element element, Element proxyElement, MigrationReport migrationReport) {
        String policyName = this.getRootElement(element).getAttributeValue(POLICY_NAME);
        if (policyName == null) {
            String defaultPolicyName = ((PomModel)this.getApplicationModel().getPomModel().get()).getArtifactId();
            migrationReport.report("basicStructure.defaultPolicyName", proxyElement, proxyElement, new String[]{defaultPolicyName});
            return defaultPolicyName;
        }
        return policyName;
    }

    private void completeMule4Element(Element element) {
        Element root = this.getRootElement(element);
        root.addNamespaceDeclaration(GatewayNamespaces.HTTP_POLICY_NAMESPACE);
        Attribute attr = this.getXSIAttribute(root);
        String uri = attr.getValue();
        attr.setValue(uri + " " + HTTP_POLICY_XSI_URI);
    }

    private Element addHttpPolicyTag(Element element, boolean modifyCurrentElement, MigrationReport migrationReport) {
        this.completeMule4Element(element);
        Element sourceElement = new Element(SOURCE_TAG_NAME, GatewayNamespaces.HTTP_POLICY_NAMESPACE);
        sourceElement.addContent((Content)new Element(EXECUTE_NEXT_TAG_NAME, GatewayNamespaces.HTTP_POLICY_NAMESPACE));
        if (modifyCurrentElement) {
            element.setName(PROXY_TAG_NAME);
            element.setNamespace(GatewayNamespaces.HTTP_POLICY_NAMESPACE);
            element.addContent((Content)sourceElement);
            element.setAttribute("name", this.getPolicyName(element, element, migrationReport));
            return element;
        }
        Element proxyElement = new Element(PROXY_TAG_NAME, GatewayNamespaces.HTTP_POLICY_NAMESPACE);
        proxyElement.addContent((Content)sourceElement);
        proxyElement.setAttribute("name", this.getPolicyName(element, proxyElement, migrationReport));
        this.getRootElement(element).addContent((Content)proxyElement.detach());
        return proxyElement;
    }

    private Element getHttpPolicyFromDocument(Element element) {
        return element.getChild(PROXY_TAG_NAME, GatewayNamespaces.HTTP_POLICY_NAMESPACE);
    }

    private boolean hasHttpPolicyBeenSetUp(Document document) {
        return document != null && this.getHttpPolicyFromDocument(document.getRootElement()) != null;
    }

    protected Element setUpHttpPolicy(Element element, boolean modifyCurrentElement, MigrationReport migrationReport) {
        Element source;
        if (!this.hasHttpPolicyBeenSetUp(element.getDocument())) {
            source = this.addHttpPolicyTag(element, modifyCurrentElement, migrationReport).getChild(SOURCE_TAG_NAME, GatewayNamespaces.HTTP_POLICY_NAMESPACE);
        } else {
            Element proxyElement = this.getRootElement(element).getChild(PROXY_TAG_NAME, GatewayNamespaces.HTTP_POLICY_NAMESPACE);
            if (proxyElement.getAttributeValue("name").equals("")) {
                proxyElement.setAttribute("name", this.getPolicyName(proxyElement, proxyElement, migrationReport));
            }
            source = proxyElement.getChild(SOURCE_TAG_NAME, GatewayNamespaces.HTTP_POLICY_NAMESPACE);
            if (modifyCurrentElement) {
                element.detach();
            }
        }
        return source;
    }

    protected int getElementPosition(Element parentElement, String tagName) {
        int[] count = new int[]{1};
        parentElement.getContent().stream().filter(content -> {
            if (content instanceof Element && ((Element)content).getName().equals(tagName)) {
                return true;
            }
            count[0] = count[0] + 1;
            return false;
        }).findFirst();
        return count[0];
    }
}

