/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.gateway.steps.policy.mule;

import com.mulesoft.tools.migration.library.gateway.steps.GatewayNamespaces;
import com.mulesoft.tools.migration.library.gateway.steps.policy.PolicyMigrationStep;
import com.mulesoft.tools.migration.library.gateway.steps.policy.mule.HttpTransformPomContributionMigrationStep;
import com.mulesoft.tools.migration.library.mule.steps.http.HttpConnectorListener;
import com.mulesoft.tools.migration.project.model.pom.PomModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SetPropertyMigrationStep
extends PolicyMigrationStep {
    private static final String POLICY_TAG_NAME = "policy";
    private static final String SET_PROPERTY_TAG_NAME = "set-property";
    private static final String OUTBOUND_PROPERTIES_TO_VAR_TAG_NAME = "outbound-properties-to-var";
    private static final String SET_RESPONSE_TAG_NAME = "set-response";
    private static final String STATUS_CODE_ATTR_NAME = "statusCode";
    private static final String HTTP_LISTENER_RESPONSE_SUCCESS_STATUS_CODE_DWL = "#[migration::HttpListener::httpListenerResponseSuccessStatusCode(vars)]";
    private static final String HEADERS_TAG_NAME = "headers";
    private static final String HTTP_LISTENER_RESPONSE_HEADERS_DWL = "#[migration::HttpListener::httpListenerResponseHeaders(vars)]";
    private static final String COMPATIBILITY_XSI_SCHEMA_LOCATION = "http://www.mulesoft.org/schema/mule/compatibility http://www.mulesoft.org/schema/mule/compatibility/current/mule-compatibility.xsd";
    private static final String HTTP_TRANSFORM_XSI_SCHEMA_LOCATION_URI = "http://www.mulesoft.org/schema/mule/http-policy-transform http://www.mulesoft.org/schema/mule/http-policy-transform/current/mule-http-policy-transform.xsd";

    public SetPropertyMigrationStep() {
        super(GatewayNamespaces.COMPATIBILITY_NAMESPACE, SET_PROPERTY_TAG_NAME);
    }

    private boolean hasElement(Element element, String targetTagName, Namespace targetNamespace) {
        return element.getChild(targetTagName, targetNamespace) != null;
    }

    private void addNamespaces(Element rootElement) {
        this.addNamespaceDeclaration(rootElement, GatewayNamespaces.HTTP_TRANSFORM_NAMESPACE, HTTP_TRANSFORM_XSI_SCHEMA_LOCATION_URI);
        this.addNamespaceDeclaration(rootElement, GatewayNamespaces.COMPATIBILITY_NAMESPACE, COMPATIBILITY_XSI_SCHEMA_LOCATION);
    }

    private void addOutboundPropertiesElement(Element parentElement, boolean hasSetResponseElement) {
        if (hasSetResponseElement) {
            parentElement.addContent(this.getElementPosition(parentElement, SET_RESPONSE_TAG_NAME) - 1, (Content)new Element(OUTBOUND_PROPERTIES_TO_VAR_TAG_NAME, GatewayNamespaces.COMPATIBILITY_NAMESPACE));
        } else {
            parentElement.addContent((Content)new Element(OUTBOUND_PROPERTIES_TO_VAR_TAG_NAME, GatewayNamespaces.COMPATIBILITY_NAMESPACE));
        }
    }

    public void execute(Element element, MigrationReport migrationReport) throws RuntimeException {
        if (this.getRootElement(element).getName().equals(POLICY_TAG_NAME)) {
            this.addNamespaces(this.getRootElement(element));
            Element parentElement = element.getParentElement();
            boolean hasSetResponseElement = this.hasElement(parentElement, SET_RESPONSE_TAG_NAME, GatewayNamespaces.HTTP_TRANSFORM_NAMESPACE);
            if (!this.hasElement(parentElement, OUTBOUND_PROPERTIES_TO_VAR_TAG_NAME, GatewayNamespaces.COMPATIBILITY_NAMESPACE)) {
                this.addOutboundPropertiesElement(parentElement, hasSetResponseElement);
            }
            if (!hasSetResponseElement) {
                parentElement.addContent((Content)new Element(SET_RESPONSE_TAG_NAME, GatewayNamespaces.HTTP_TRANSFORM_NAMESPACE).setAttribute(STATUS_CODE_ATTR_NAME, HTTP_LISTENER_RESPONSE_SUCCESS_STATUS_CODE_DWL).addContent((Content)new Element(HEADERS_TAG_NAME, GatewayNamespaces.HTTP_TRANSFORM_NAMESPACE).addContent(HTTP_LISTENER_RESPONSE_HEADERS_DWL)));
                HttpConnectorListener.httpListenerLib(this.getApplicationModel());
                new HttpTransformPomContributionMigrationStep().execute((PomModel)this.getApplicationModel().getPomModel().get(), migrationReport);
                HttpConnectorListener.httpListenerLib(this.getApplicationModel());
            }
        }
    }
}

