/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.amqp;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.amqp.AbstractAmqpEndpoint;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.Optional;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class AmqpInboundEndpoint
extends AbstractAmqpEndpoint {
    public static final String XPATH_SELECTOR = "//*[(namespace-uri()='http://www.mulesoft.org/schema/mule/amqp' or namespace-uri()='http://www.mulesoft.org/schema/mule/amqps') and local-name()='inbound-endpoint']";

    public String getDescription() {
        return "Update AMQP transport inbound endpoint.";
    }

    public AmqpInboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{AMQP_NAMESPACE, AMQPS_NAMESPACE}));
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        XmlDslUtils.addMigrationAttributeToElement((Element)object, (Attribute)new Attribute("isMessageSource", "true"));
        object.setNamespace(AMQP_NAMESPACE);
        object.setName("listener");
        Element tx = object.getChild("transaction", AMQP_NAMESPACE);
        while (tx != null) {
            String txAction = this.mapTransactionalAction(tx.getAttributeValue("action"), report, tx, object);
            object.setAttribute("transactionalAction", txAction);
            XmlDslUtils.copyAttributeIfPresent((Element)tx, (Element)object, (String)"recoverStrategy");
            object.removeChild("transaction", AMQP_NAMESPACE);
            tx = object.getChild("transaction", AMQP_NAMESPACE);
        }
        Optional<Element> connector = AmqpInboundEndpoint.resolveAmqpConnector(object, this.getApplicationModel());
        String configName = AmqpInboundEndpoint.migrateAmqpConfig(object, report, connector, this.getApplicationModel());
        connector.ifPresent(m3c -> {
            Element reconnect;
            Element reconnectforever = m3c.getChild("reconnect-forever", XmlDslUtils.CORE_NAMESPACE);
            if (reconnectforever != null) {
                object.addContent((Content)new Element("reconnect-forever", XmlDslUtils.CORE_NAMESPACE).setAttribute("frequency", reconnectforever.getAttributeValue("frequency")));
            }
            if ((reconnect = m3c.getChild("reconnect", XmlDslUtils.CORE_NAMESPACE)) != null) {
                object.addContent((Content)new Element("reconnect", XmlDslUtils.CORE_NAMESPACE).setAttribute("frequency", reconnect.getAttributeValue("frequency")).setAttribute("count", reconnect.getAttributeValue("count")));
            }
            TransportsUtils.handleConnectorChildElements((Element)m3c, (Element)this.getApplicationModel().getNode("*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/amqp' and local-name()='config' and @name='" + configName + "']"), (Element)new Element("connection", XmlDslUtils.CORE_NAMESPACE), (MigrationReport)report);
        });
        object.setAttribute("config-ref", configName);
        if (XmlDslUtils.hasAttribute((Element)object, (String)"exchangeAutoDelete") || XmlDslUtils.hasAttribute((Element)object, (String)"exchangeDurable") || XmlDslUtils.hasAttribute((Element)object, (String)"exchangeType") || XmlDslUtils.hasAttribute((Element)object, (String)"routingKey")) {
            object.removeAttribute("exchangeAutoDelete");
            object.removeAttribute("exchangeDurable");
            object.removeAttribute("exchangeType");
            object.removeAttribute("routingKey");
            report.report("amqp.exchangeDefinition", object, object, new String[0]);
        }
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)object, (String)"numberOfChannels", (String)"numberOfConsumers");
        object.removeAttribute("numberOfChannels");
        this.resolveFallbackQueue(object, report);
    }

    private void resolveFallbackQueue(Element object, MigrationReport report) {
        Element queueDefinition = new Element("fallback-queue-definition", AMQP_NAMESPACE);
        Boolean autoDelete = Boolean.parseBoolean(object.getAttributeValue("queueAutoDelete"));
        Boolean queueDurable = Boolean.parseBoolean(object.getAttributeValue("queueDurable"));
        object.removeAttribute("queueAutoDelete");
        object.removeAttribute("queueDurable");
        String removalStrategy = this.resolveRemovalStrategy(autoDelete, queueDurable);
        if (removalStrategy != null) {
            queueDefinition.setAttribute("removalStrategy", removalStrategy);
        } else {
            report.report("amqp.queueRemovalStrategy", object, queueDefinition, new String[0]);
        }
        if (XmlDslUtils.hasAttribute((Element)object, (String)"exchangeName")) {
            queueDefinition.setAttribute("exchangeToBind", object.getAttributeValue("exchangeName"));
            object.removeAttribute("exchangeName");
        }
        object.addContent((Content)queueDefinition);
    }

    private String mapTransactionalAction(String action, MigrationReport report, Element tx, Element object) {
        if ("NONE".equals(action)) {
            return "NONE";
        }
        if ("ALWAYS_BEGIN".equals(action)) {
            return "ALWAYS_BEGIN";
        }
        if ("BEGIN_OR_JOIN".equals(action)) {
            report.report("amqp.listenerTx", tx, object, new String[0]);
            return "ALWAYS_BEGIN";
        }
        if ("ALWAYS_JOIN".equals(action)) {
            report.report("amqp.listenerTx", tx, object, new String[0]);
            return "NONE";
        }
        if ("JOIN_IF_POSSIBLE".equals(action)) {
            report.report("amqp.listenerTx", tx, object, new String[0]);
            return "NONE";
        }
        if ("NOT_SUPPORTED".equals(action)) {
            return "NONE";
        }
        return action;
    }
}

