/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.batch;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.ArrayList;
import java.util.Optional;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class BatchJob
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    public static final String BATCH_NAMESPACE_PREFIX = "batch";
    public static final String BATCH_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/batch";
    private static final Namespace BATCH_NAMESPACE = Namespace.getNamespace((String)"batch", (String)"http://www.mulesoft.org/schema/mule/batch");
    public static final String XPATH_SELECTOR = "/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/batch' and local-name()='job']";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Update batch job to a flow with equal name that contains the actual batch job.";
    }

    public BatchJob() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{BATCH_NAMESPACE}));
    }

    public void execute(Element originalBatchJob, MigrationReport report) throws RuntimeException {
        Element batchJob = new Element("job", BATCH_NAMESPACE);
        this.setAttributes(originalBatchJob, batchJob);
        Optional<Element> batchInput = Optional.ofNullable(originalBatchJob.getChild("input", BATCH_NAMESPACE));
        batchInput.ifPresent(input -> originalBatchJob.removeContent((Content)input));
        Optional<Element> batchThreadingProfile = Optional.ofNullable(originalBatchJob.getChild("threading-profile", BATCH_NAMESPACE));
        batchThreadingProfile.ifPresent(threadingProfile -> {
            originalBatchJob.removeContent((Content)threadingProfile);
            String maxThreadsActive = threadingProfile.getAttributeValue("maxThreadsActive");
            if (maxThreadsActive != null) {
                batchJob.setAttribute("maxConcurrency", maxThreadsActive);
            }
            report.report("flow.threading", originalBatchJob, originalBatchJob, new String[0]);
        });
        ArrayList children = new ArrayList(originalBatchJob.getChildren());
        children.forEach(child -> {
            originalBatchJob.removeContent((Content)child);
            batchJob.addContent((Content)child);
        });
        batchInput.ifPresent(input -> {
            ArrayList inputChildren = new ArrayList(input.getChildren());
            inputChildren.forEach(child -> {
                input.removeContent((Content)child);
                originalBatchJob.addContent((Content)child);
            });
        });
        originalBatchJob.addContent((Content)batchJob);
        originalBatchJob.setNamespace(XmlDslUtils.CORE_NAMESPACE);
        originalBatchJob.setName("flow");
    }

    private void moveAttribute(Element originalBatchJob, Element batchJob, String oldName, String newName, boolean expression) {
        Optional.ofNullable(originalBatchJob.getAttributeValue(oldName)).ifPresent(value -> {
            originalBatchJob.removeAttribute(oldName);
            batchJob.setAttribute(newName, expression ? this.expressionMigrator.migrateExpression(value, true, originalBatchJob) : value);
        });
    }

    private void setAttributes(Element originalBatchJob, Element batchJob) {
        batchJob.setAttribute("jobName", originalBatchJob.getAttributeValue("name"));
        this.moveAttribute(originalBatchJob, batchJob, "scheduling-strategy", "schedulingStrategy", false);
        this.moveAttribute(originalBatchJob, batchJob, "max-failed-records", "maxFailedRecords", false);
        this.moveAttribute(originalBatchJob, batchJob, "block-size", "blockSize", false);
        this.moveAttribute(originalBatchJob, batchJob, "job-instance-id", "jobInstanceId", true);
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

