/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.batch;

import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class BatchStep
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    public static final String BATCH_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/batch";
    public static final String XPATH_SELECTOR = "//*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/batch' and local-name() = 'step']";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Update batch step attributes.";
    }

    public BatchStep() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        Attribute filterExpression;
        Attribute acceptExpression;
        Attribute acceptPolicy = object.getAttribute("accept-policy");
        if (acceptPolicy != null) {
            acceptPolicy.setName("acceptPolicy");
        }
        if ((acceptExpression = object.getAttribute("accept-expression")) != null) {
            acceptExpression.setName("acceptExpression");
            acceptExpression.setValue(this.expressionMigrator.migrateExpression(acceptExpression.getValue(), true, object));
        }
        if ((filterExpression = object.getAttribute("filter-expression")) != null) {
            report.report("batch.filterExpression", object, object, new String[0]);
        }
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

