/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class MessageAttachmentsListExpressionEvaluator
extends AbstractApplicationModelMigrationStep {
    public static final String XPATH_SELECTOR = "//mule:expression-transformer[@evaluator='attachments-list']";

    public String getDescription() {
        return "Migrate <expression-transformer evaluator=\"attachments-list\"/> to individual processors.";
    }

    public MessageAttachmentsListExpressionEvaluator() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{TransportsUtils.COMPATIBILITY_NAMESPACE}));
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        object.setName("set-payload");
        object.removeAttribute("evaluator");
        String expression = "*";
        if (object.getAttribute("expression") != null) {
            expression = object.getAttributeValue("expression");
        }
        object.removeAttribute("expression");
        if ("*".equals(expression)) {
            object.setAttribute("value", "#[payload.attachments pluck ((value, key, index) -> value)]");
        } else {
            String asRegex = "^" + expression.replaceAll("\\*", ".*") + "$";
            object.setAttribute("value", "#[payload.attachments filterObject ((value,key) -> ((key as String) matches /" + asRegex + "/)) pluck ((value, key, index) -> value)]");
        }
    }
}

