/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.email;

import com.mulesoft.tools.migration.library.mule.steps.core.dw.DataWeaveHelper;
import com.mulesoft.tools.migration.library.mule.steps.email.AbstractEmailMigrator;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.io.IOException;
import java.util.Optional;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Text;

public class SmtpOutboundEndpoint
extends AbstractEmailMigrator
implements ExpressionMigratorAware {
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/smtp' and local-name()='outbound-endpoint']";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Update SMTP transport outbound endpoint.";
    }

    public SmtpOutboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        SmtpOutboundEndpoint.smtpTransportLib(this.getApplicationModel());
        object.setName("send");
        object.setNamespace(EMAIL_NAMESPACE);
        Optional<Element> smtpConnector = this.resolveConnector(object, this.getApplicationModel());
        smtpConnector.ifPresent(c -> {
            TransportsUtils.handleServiceOverrides((Element)c, (MigrationReport)report);
            XmlDslUtils.migrateReconnection((Element)c, (Element)object, (MigrationReport)report);
            if (c.getAttribute("toAddresses") != null) {
                object.setAttribute("tc", c.getAttributeValue("toAddresses"));
            }
            if (c.getAttribute("ccAddresses") != null) {
                object.setAttribute("cc", c.getAttributeValue("ccAddresses"));
            }
            if (c.getAttribute("bccAddresses") != null) {
                object.setAttribute("bcc", c.getAttributeValue("bccAddresses"));
            }
            if (c.getAttribute("fromAddress") != null) {
                object.setAttribute("fromAddress", c.getAttributeValue("fromAddress"));
            }
            if (c.getAttribute("replyToAddresses") != null) {
                object.setAttribute("replyTo", c.getAttributeValue("replyToAddresses"));
            }
            if (c.getAttribute("subject") != null) {
                object.setAttribute("subject", c.getAttributeValue("subject"));
            }
        });
        this.getApplicationModel().addNameSpace(EMAIL_NAMESPACE.getPrefix(), EMAIL_NAMESPACE.getURI(), "http://www.mulesoft.org/schema/mule/email/current/mule-email.xsd");
        Element m4Config = this.migrateSmtpConfig(object, report, smtpConnector);
        Element connection = this.getConnection(m4Config);
        if (smtpConnector.isPresent() && "gmail-connector".equals(smtpConnector.get().getName())) {
            connection.setName("smtps-connection");
            connection.addContent((Content)new Element("context", TLS_NAMESPACE).addContent((Content)new Element("trust-store", TLS_NAMESPACE).setAttribute("insecure", "true")));
            connection.setAttribute("host", "smtp.gmail.com");
            connection.setAttribute("port", "465");
            object.removeAttribute("host");
            object.removeAttribute("port");
            this.getApplicationModel().addNameSpace(TLS_NAMESPACE.getPrefix(), TLS_NAMESPACE.getURI(), "http://www.mulesoft.org/schema/mule/tls/current/mule-tls.xsd");
            report.report("email.gmail", smtpConnector.get(), connection, new String[0]);
        } else {
            if (object.getAttribute("host") != null) {
                object.setAttribute("host", this.expressionMigrator.migrateExpression(object.getAttributeValue("host"), false, object));
            }
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"host");
            XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"port");
            TransportsUtils.processAddress((Element)object, (MigrationReport)report).ifPresent(address -> {
                connection.setAttribute("host", address.getHost());
                connection.setAttribute("port", address.getPort());
                if (address.getCredentials() != null) {
                    String[] credsSplit = address.getCredentials().split(":");
                    connection.setAttribute("user", credsSplit[0]);
                    connection.setAttribute("password", credsSplit[1]);
                }
            });
        }
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"user");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"password");
        if (object.getAttribute("connector-ref") != null) {
            object.getAttribute("connector-ref").setName("config-ref");
        } else {
            object.removeAttribute("name");
            object.setAttribute("config-ref", m4Config.getAttributeValue("name"));
        }
        report.report("email.outbound", object, object, new String[0]);
        object.setAttribute("fromAddress", this.smtpAttributeExpr("#[vars.compatibility_outboundProperties.fromAddress]", object.getAttribute("fromAddress")));
        object.setAttribute("subject", this.smtpAttributeExpr("#[vars.compatibility_outboundProperties.subject]", object.getAttribute("subject")));
        object.addContent((Content)new Element("to-addresses", EMAIL_NAMESPACE).addContent((Content)new Element("to-address", EMAIL_NAMESPACE).setAttribute("value", this.smtpAttributeExpr("#[migration::SmtpTransport::smptToAddress(vars)]", object.getAttribute("to")))));
        object.addContent((Content)new Element("cc-addresses", EMAIL_NAMESPACE).addContent((Content)new Element("cc-address", EMAIL_NAMESPACE).setAttribute("value", this.smtpAttributeExpr("#[migration::SmtpTransport::smptCcAddress(vars)]", object.getAttribute("cc")))));
        object.addContent((Content)new Element("bcc-addresses", EMAIL_NAMESPACE).addContent((Content)new Element("bcc-address", EMAIL_NAMESPACE).setAttribute("value", this.smtpAttributeExpr("#[migration::SmtpTransport::smptBccAddress(vars)]", object.getAttribute("bcc")))));
        object.addContent((Content)new Element("reply-to-addresses", EMAIL_NAMESPACE).addContent((Content)new Element("reply-to-address", EMAIL_NAMESPACE).setAttribute("value", this.smtpAttributeExpr("#[migration::SmtpTransport::smptReplyToAddress(vars)]", object.getAttribute("replyTo")))));
        object.addContent((Content)new Element("headers", EMAIL_NAMESPACE).addContent((Content)new Text("#[vars.compatibility_outboundProperties.customHeaders]")));
        object.addContent((Content)new Element("body", EMAIL_NAMESPACE).setAttribute("contentType", "#[payload.^mimeType]").addContent((Content)new Element("content", EMAIL_NAMESPACE).addContent((Content)new Text("#[payload]"))));
        object.addContent((Content)new Element("attachments", EMAIL_NAMESPACE).addContent((Content)new Text("#[vars filterObject ((value,key) -> ((key as String) startsWith 'att_')) pluck ((value, key, index) -> value)]")));
        object.removeAttribute("to");
        object.removeAttribute("cc");
        object.removeAttribute("bcc");
        object.removeAttribute("replyTo");
        TransportsUtils.migrateOutboundEndpointStructure((ApplicationModel)this.getApplicationModel(), (Element)object, (MigrationReport)report, (boolean)false);
    }

    private String smtpAttributeExpr(String propsBase, Attribute endpointAttr) {
        if (endpointAttr == null) {
            return propsBase;
        }
        String original = endpointAttr.getValue();
        String defaultValue = this.expressionMigrator.isWrapped(original) ? this.expressionMigrator.unwrap(this.expressionMigrator.migrateExpression(original, true, endpointAttr.getParent())) : "'" + original + "'";
        String newExpr = this.expressionMigrator.wrap(this.expressionMigrator.unwrap(propsBase) + " default " + defaultValue);
        endpointAttr.detach();
        return newExpr;
    }

    public Element migrateSmtpConfig(Element object, MigrationReport report, Optional<Element> connector) {
        String configName = connector.map(conn -> conn.getAttributeValue("name")).orElse((object.getAttribute("name") != null ? object.getAttributeValue("name") : (object.getAttribute("ref") != null ? object.getAttributeValue("ref") : "")).replaceAll("\\\\", "_") + "SmtpConfig");
        Optional config = this.getApplicationModel().getNodeOptional("*/*[namespace-uri() = '" + EMAIL_NAMESPACE.getURI() + "' and local-name() = 'smtp-config' and @name='" + configName + "']");
        return config.orElseGet(() -> {
            Element smtpCfg = new Element("smtp-config", EMAIL_NAMESPACE);
            smtpCfg.setAttribute("name", configName);
            Element connection = this.createConnection();
            smtpCfg.addContent((Content)connection);
            XmlDslUtils.addTopLevelElement((Element)smtpCfg, (Document)connector.map(c -> c.getDocument()).orElse(object.getDocument()));
            return smtpCfg;
        });
    }

    @Override
    protected Element getConnector(String connectorName) {
        return this.getApplicationModel().getNode("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/smtp' and (local-name()='connector' or local-name()='gmail-connector') and @name = '" + connectorName + "']");
    }

    protected Element createConnection() {
        return new Element("smtp-connection", EMAIL_NAMESPACE);
    }

    protected Element getConnection(Element m4Config) {
        return m4Config.getChild("smtp-connection", EMAIL_NAMESPACE);
    }

    @Override
    protected Optional<Element> getDefaultConnector() {
        return this.getApplicationModel().getNodeOptional("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/smtp' and (local-name()='connector' or local-name()='gmail-connector')]");
    }

    public static void smtpTransportLib(ApplicationModel appModel) {
        try {
            DataWeaveHelper.library(DataWeaveHelper.getMigrationScriptFolder(appModel.getProjectBasePath()), "SmtpTransport.dwl", "fun smptToAddress(vars: {}) = do {" + System.lineSeparator() + "    vars.compatibility_outboundProperties.toAddresses[0]" + System.lineSeparator() + "}" + System.lineSeparator() + "" + System.lineSeparator() + "fun smptCcAddress(vars: {}) = do {" + System.lineSeparator() + "    vars.compatibility_outboundProperties.ccAddresses[0]" + System.lineSeparator() + "}" + System.lineSeparator() + "" + System.lineSeparator() + "fun smptBccAddress(vars: {}) = do {" + System.lineSeparator() + "    vars.compatibility_outboundProperties.bccAddresses[0]" + System.lineSeparator() + "}" + System.lineSeparator() + "" + System.lineSeparator() + "fun smptFromAddress(vars: {}) = do {" + System.lineSeparator() + "    vars.compatibility_outboundProperties.fromAddress" + System.lineSeparator() + "}" + System.lineSeparator() + "" + System.lineSeparator() + "fun smptReplyToAddress(vars: {}) = do {" + System.lineSeparator() + "    vars.compatibility_outboundProperties.replyToAddresses[0]" + System.lineSeparator() + "}" + System.lineSeparator() + "" + System.lineSeparator() + "fun smptSubject(vars: {}) = do {" + System.lineSeparator() + "    vars.compatibility_outboundProperties.subject" + System.lineSeparator() + "}" + System.lineSeparator() + "" + System.lineSeparator() + System.lineSeparator());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

