/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.file;

import com.mulesoft.tools.migration.library.mule.steps.core.properties.InboundPropertiesHelper;
import com.mulesoft.tools.migration.library.mule.steps.file.FileConfig;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.OptionalInt;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class FileInboundEndpoint
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    public static final String XPATH_SELECTOR = "/*/mule:flow/*[namespace-uri()='http://www.mulesoft.org/schema/mule/file' and local-name()='inbound-endpoint'][1]";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Update File inbound endpoints.";
    }

    public FileInboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        object.setName("listener");
        XmlDslUtils.addMigrationAttributeToElement((Element)object, (Attribute)new Attribute("isMessageSource", "true"));
        this.addAttributesToInboundProperties(object, report);
        Element redelivery = object.getChild("idempotent-redelivery-policy", XmlDslUtils.CORE_NAMESPACE);
        if (redelivery != null) {
            redelivery.setName("redelivery-policy");
            Attribute exprAttr = redelivery.getAttribute("idExpression");
            if (exprAttr != null) {
                exprAttr.setValue(exprAttr.getValue().replaceAll("#\\[header\\:inbound\\:originalFilename\\]", "#[attributes.name]"));
                if (this.getExpressionMigrator().isWrapped(exprAttr.getValue())) {
                    exprAttr.setValue(this.getExpressionMigrator().wrap(this.getExpressionMigrator().migrateExpression(exprAttr.getValue(), true, object)));
                }
            }
            XmlDslUtils.migrateRedeliveryPolicyChildren((Element)redelivery, (MigrationReport)report);
        }
        TransportsUtils.migrateSchedulingStrategy((Element)object, (OptionalInt)OptionalInt.of(1000));
        if (object.getAttribute("fileAge") != null && !"0".equals(object.getAttributeValue("fileAge"))) {
            String fileAge = object.getAttributeValue("fileAge");
            object.setAttribute("timeBetweenSizeCheck", fileAge);
            object.removeAttribute("fileAge");
        }
        if (object.getAttribute("moveToPattern") != null) {
            String moveToPattern = object.getAttributeValue("moveToPattern");
            object.setAttribute("renameTo", this.getExpressionMigrator().migrateExpression(moveToPattern, true, object));
            object.removeAttribute("moveToPattern");
        }
        if (object.getAttribute("moveToDirectory") != null && "true".equals(object.getAttributeValue("autoDelete"))) {
            object.removeAttribute("autoDelete");
        }
        FileInboundEndpoint.migrateFileFilters(object, report, FileConfig.FILE_NAMESPACE, this.getApplicationModel());
        object.setAttribute("applyPostActionWhenFailed", "false");
        String recursive = XmlDslUtils.changeDefault((String)"false", (String)"true", (String)object.getAttributeValue("recursive"));
        if (recursive != null) {
            object.setAttribute("recursive", recursive);
        } else {
            object.removeAttribute("recursive");
        }
        TransportsUtils.processAddress((Element)object, (MigrationReport)report).ifPresent(address -> object.setAttribute("directory", address.getPath()));
        if (object.getAttribute("path") != null) {
            object.getAttribute("path").setName("directory");
        }
        if (object.getAttribute("connector-ref") != null) {
            object.getAttribute("connector-ref").setName("config-ref");
        } else {
            object.setAttribute("autoDelete", "true");
            object.setAttribute("recursive", "false");
        }
        if (object.getAttribute("encoding") != null) {
            object.getParent().addContent(3, (Content)new Element("set-payload", XmlDslUtils.CORE_NAMESPACE).setAttribute("value", "#[payload]").setAttribute("encoding", object.getAttributeValue("encoding")));
            object.removeAttribute("encoding");
        }
        if (object.getAttribute("responseTimeout") != null) {
            report.report("file.responseTimeout", object, object, new String[0]);
            object.removeAttribute("responseTimeout");
        }
        if (object.getAttribute("comparator") != null || object.getAttribute("reverseOrder") != null) {
            report.report("file.comparator", object, object, new String[0]);
            object.removeAttribute("comparator");
            object.removeAttribute("reverseOrder");
        }
        if (object.getAttribute("name") != null) {
            object.removeAttribute("name");
        }
        if (object.getAttribute("exchange-pattern") != null) {
            object.removeAttribute("exchange-pattern");
        }
    }

    public static void migrateFileFilters(Element object, MigrationReport report, Namespace ns, ApplicationModel appModel) {
        Element regexFilter;
        Element globFilter;
        Element regexFilterIn;
        Element customFilterIn;
        Element newMatcher = null;
        Element globFilterIn = object.getChild("filename-wildcard-filter", FileConfig.FILE_NAMESPACE);
        if (globFilterIn != null) {
            if (newMatcher == null) {
                newMatcher = FileInboundEndpoint.buildNewMatcher(object, ns, appModel);
            }
            newMatcher.setAttribute("filenamePattern", globFilterIn.getAttributeValue("pattern"));
            if (globFilterIn.getAttribute("caseSensitive") != null) {
                report.report("file.caseSensitive", globFilterIn, newMatcher, new String[0]);
                globFilterIn.removeAttribute("caseSensitive");
            }
            object.removeContent((Content)globFilterIn);
        }
        if ((customFilterIn = object.getChild("custom-filter", TransportsUtils.COMPATIBILITY_NAMESPACE)) != null) {
            object.removeContent((Content)customFilterIn);
            object.getParentElement().addContent(3, (Content)customFilterIn);
        }
        if ((regexFilterIn = object.getChild("filename-regex-filter", FileConfig.FILE_NAMESPACE)) != null) {
            if (newMatcher == null) {
                newMatcher = FileInboundEndpoint.buildNewMatcher(object, ns, appModel);
            }
            newMatcher.setAttribute("filenamePattern", "regex:" + regexFilterIn.getAttributeValue("pattern"));
            if (regexFilterIn.getAttribute("caseSensitive") != null) {
                report.report("file.caseSensitive", regexFilterIn, newMatcher, new String[0]);
                regexFilterIn.removeAttribute("caseSensitive");
            }
            object.removeContent((Content)regexFilterIn);
        }
        if ((globFilter = object.getParentElement().getChild("filename-wildcard-filter", FileConfig.FILE_NAMESPACE)) != null) {
            if (newMatcher == null) {
                newMatcher = FileInboundEndpoint.buildNewMatcher(object, ns, appModel);
            }
            newMatcher.setAttribute("filenamePattern", globFilter.getAttributeValue("pattern"));
            if (globFilter.getAttribute("caseSensitive") != null) {
                report.report("file.caseSensitive", globFilter, newMatcher, new String[0]);
                globFilter.removeAttribute("caseSensitive");
            }
            object.getParentElement().removeContent((Content)globFilter);
        }
        if ((regexFilter = object.getParentElement().getChild("filename-regex-filter", FileConfig.FILE_NAMESPACE)) != null) {
            if (newMatcher == null) {
                newMatcher = FileInboundEndpoint.buildNewMatcher(object, ns, appModel);
            }
            newMatcher.setAttribute("filenamePattern", "regex:" + regexFilter.getAttributeValue("pattern"));
            if (regexFilter.getAttribute("caseSensitive") != null) {
                report.report("file.caseSensitive", regexFilter, newMatcher, new String[0]);
                regexFilter.removeAttribute("caseSensitive");
            }
            object.getParentElement().removeContent((Content)regexFilter);
        }
    }

    private static Element buildNewMatcher(Element object, Namespace ns, ApplicationModel appModel) {
        Element newMatcher = new Element("matcher", ns);
        List referencedMatcher = appModel.getNodes("/*/" + ns.getPrefix() + ":matcher[@name='" + object.getAttributeValue("matcher") + "']");
        if (!referencedMatcher.isEmpty()) {
            for (Attribute attribute : ((Element)referencedMatcher.get(0)).getAttributes()) {
                newMatcher.setAttribute(attribute.getName(), attribute.getValue());
            }
        }
        String newMatcherName = (object.getAttributeValue("connector-ref") != null ? object.getAttributeValue("connector-ref") + "-" : "") + object.getParentElement().getAttributeValue("name") + "Matcher";
        newMatcher.setAttribute("name", newMatcherName);
        object.setAttribute("matcher", newMatcherName);
        int idx = object.getDocument().getRootElement().indexOf((Content)object.getParentElement());
        object.getDocument().getRootElement().addContent(idx, (Content)newMatcher);
        return newMatcher;
    }

    private void addAttributesToInboundProperties(Element object, MigrationReport report) {
        TransportsUtils.migrateInboundEndpointStructure((ApplicationModel)this.getApplicationModel(), (Element)object, (MigrationReport)report, (boolean)true);
        LinkedHashMap<String, String> expressionsPerProperty = new LinkedHashMap<String, String>();
        expressionsPerProperty.put("originalFilename", "message.attributes.fileName");
        expressionsPerProperty.put("originalDirectory", "(message.attributes.path as String) [0 to -(2 + sizeOf(message.attributes.fileName))]");
        expressionsPerProperty.put("sourceFileName", "message.attributes.fileName");
        expressionsPerProperty.put("sourceDirectory", "(message.attributes.path as String) [0 to -(2 + sizeOf(message.attributes.fileName))]");
        expressionsPerProperty.put("filename", "message.attributes.fileName");
        expressionsPerProperty.put("directory", "(message.attributes.path as String) [0 to -(2 + sizeOf(message.attributes.fileName))]");
        expressionsPerProperty.put("fileSize", "message.attributes.size");
        expressionsPerProperty.put("timestamp", "message.attributes.lastModifiedTime");
        expressionsPerProperty.put("MULE.FORCE_SYNC", "false");
        try {
            InboundPropertiesHelper.addAttributesMapping(this.getApplicationModel(), "org.mule.extension.file.api.LocalFileAttributes", expressionsPerProperty, new String[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

