/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.ftp;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.ftp.FtpConfig;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.util.stream.Stream;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class FtpEeConfig
extends FtpConfig {
    private static final String FTP_EE_NAMESPACE_PREFIX = "ftp-ee";
    private static final String FTP_EE_NS_URI = "http://www.mulesoft.org/schema/mule/ee/ftp";
    public static final Namespace FTP_EE_NAMESPACE = Namespace.getNamespace((String)"ftp-ee", (String)"http://www.mulesoft.org/schema/mule/ee/ftp");
    public static final String XPATH_SELECTOR = "/*/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/ee/ftp' and local-name() = 'connector']";

    @Override
    public String getDescription() {
        return "Update FTP-ee connector config.";
    }

    public FtpEeConfig() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{FTP_NAMESPACE}));
    }

    @Override
    public void execute(Element object, MigrationReport report) throws RuntimeException {
        super.execute(object, report);
        String fileAge = null;
        if (object.getAttribute("fileAge") != null) {
            fileAge = object.getAttributeValue("fileAge");
            object.removeAttribute("fileAge");
        }
        this.handleInputSpecificAttributes(object, fileAge, report);
    }

    private void handleInputSpecificAttributes(Element object, String fileAge, MigrationReport report) {
        Stream.concat(this.getApplicationModel().getNodes("//*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/ee/ftp' and local-name() = 'inbound-endpoint' and @connector-ref='" + object.getAttributeValue("name") + "']").stream(), this.getApplicationModel().getNodes("//mule:inbound-endpoint[@connector-ref='" + object.getAttributeValue("name") + "']").stream()).forEach(e -> this.passConnectorConfigToInboundEnpoint(object, fileAge, (Element)e));
        object.removeAttribute("moveToDirectory");
        object.removeAttribute("moveToPattern");
    }

    private void passConnectorConfigToInboundEnpoint(Element object, String fileAge, Element listener) {
        if (fileAge != null && !"0".equals(fileAge)) {
            listener.setAttribute("timeBetweenSizeCheck", fileAge);
        }
        if (object.getAttribute("moveToDirectory") != null && listener.getAttribute("moveToDirectory") == null) {
            listener.setAttribute("moveToDirectory", object.getAttributeValue("moveToDirectory"));
        }
        if (object.getAttribute("moveToPattern") != null) {
            String moveToPattern = object.getAttributeValue("moveToPattern");
            listener.setAttribute("renameTo", this.getExpressionMigrator().migrateExpression(moveToPattern, true, listener));
        }
    }
}

