/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.http;

import com.mulesoft.tools.migration.library.mule.steps.validation.ValidationMigration;
import com.mulesoft.tools.migration.library.mule.steps.validation.ValidationPomContribution;
import com.mulesoft.tools.migration.project.model.pom.PomModel;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import org.jdom2.Content;
import org.jdom2.Element;

public class HttpTransformers
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and (local-name()='body-to-parameter-map-transformer' or local-name()='request-wildcard-filter' or local-name()='http-response-to-object-transformer' or local-name()='http-response-to-string-transformer' or local-name()='object-to-http-request-transformer' or local-name()='message-to-http-response-transformer' or local-name()='body-to-parameter-map-transformer')]";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Update HTTP tranformers.";
    }

    public HttpTransformers() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        if ("request-wildcard-filter".equals(object.getName())) {
            String regex;
            ValidationPomContribution.addValidationDependency((PomModel)this.getApplicationModel().getPomModel().get());
            ValidationMigration.addValidationNamespace(object.getDocument());
            Element wildcardFilterTryScope = new Element("try", XmlDslUtils.CORE_NAMESPACE);
            Element matchValidator = new Element("matches-regex", ValidationMigration.VALIDATION_NAMESPACE);
            Element parent = object.getParentElement();
            if ("not-filter".equals(parent.getName()) && parent.getNamespace().equals((Object)XmlDslUtils.CORE_NAMESPACE)) {
                XmlDslUtils.addElementAfter((Element)wildcardFilterTryScope, (Element)object.getParentElement());
                object.getParentElement().detach();
                regex = "^(?!" + object.getAttributeValue("pattern").replaceAll("\\*", ".*") + ").*$";
            } else {
                regex = "^" + object.getAttributeValue("pattern").replaceAll("\\*", ".*") + "$";
                XmlDslUtils.addElementAfter((Element)wildcardFilterTryScope, (Element)object);
                object.detach();
            }
            matchValidator.setAttribute("value", "#[message.attributes.requestPath]");
            matchValidator.setAttribute("regex", regex);
            matchValidator.removeAttribute("pattern");
            wildcardFilterTryScope.addContent((Content)matchValidator);
            wildcardFilterTryScope.addContent((Content)new Element("error-handler", XmlDslUtils.CORE_NAMESPACE).addContent((Content)new Element("on-error-propagate", XmlDslUtils.CORE_NAMESPACE).addContent((Content)new Element("set-variable", XmlDslUtils.CORE_NAMESPACE).setAttribute("variableName", "statusCode").setAttribute("value", "406")).setAttribute("type", "MULE:VALIDATION")));
        } else if ("body-to-parameter-map-transformer".equals(object.getName())) {
            Element bodyToParamMap = new Element("set-payload", XmlDslUtils.CORE_NAMESPACE).setAttribute("value", "#[output application/java --- payload]");
            if (object.getParentElement() == object.getDocument().getRootElement()) {
                this.getApplicationModel().getNodes("//mule:transformer[@ref='" + object.getAttributeValue("name") + "']").forEach(t -> {
                    XmlDslUtils.addElementAfter((Element)bodyToParamMap, (Element)t);
                    t.detach();
                });
            } else {
                XmlDslUtils.addElementAfter((Element)bodyToParamMap, (Element)object);
            }
            object.detach();
        } else {
            if (object.getAttribute("name") != null) {
                this.getApplicationModel().getNodes("//mule:transformer[@ref = '" + object.getAttributeValue("name") + "']").forEach(t -> t.detach());
            }
            object.detach();
        }
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

