/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.http;

import com.mulesoft.tools.migration.library.mule.steps.http.AbstractHttpConnectorMigrationStep;
import com.mulesoft.tools.migration.library.mule.steps.http.HttpOutboundEndpoint;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.Optional;
import org.jdom2.Content;
import org.jdom2.Element;

public class HttpsOutboundEndpoint
extends HttpOutboundEndpoint {
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/https' and local-name()='outbound-endpoint']";

    @Override
    public String getDescription() {
        return "Update HTTPs transport outbound endpoint.";
    }

    public HttpsOutboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    @Override
    public void execute(Element object, MigrationReport report) throws RuntimeException {
        Optional<Element> httpsConnector = object.getAttribute("connector-ref") != null ? Optional.of(this.getConnector(object.getAttributeValue("connector-ref"))) : this.getDefaultConnector();
        super.execute(object, report);
        Element httpsRequesterConnection = this.getApplicationModel().getNode("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and local-name()='request-config' and @name = '" + object.getAttributeValue("config-ref") + "']/*[namespace-uri()='" + "http://www.mulesoft.org/schema/mule/http" + "' and local-name()='request-connection']");
        HttpsOutboundEndpoint.migrate(httpsRequesterConnection, httpsConnector, report, this.getApplicationModel(), "tls-client");
    }

    public static void migrate(Element httpsRequesterConnection, Optional<Element> httpsConnector, MigrationReport report, ApplicationModel appModel, String tlsClientTagName) {
        httpsRequesterConnection.setAttribute("protocol", "HTTPS");
        if (httpsConnector.isPresent() && httpsRequesterConnection.getChild("context", AbstractHttpConnectorMigrationStep.TLS_NAMESPACE) == null) {
            Element tlsKeyStore;
            Element tlsContext = new Element("context", AbstractHttpConnectorMigrationStep.TLS_NAMESPACE);
            boolean tlsConfigured = false;
            Element tlsClient = httpsConnector.get().getChild(tlsClientTagName, AbstractHttpConnectorMigrationStep.HTTPS_NAMESPACE);
            if (tlsClient != null) {
                Element keyStore = new Element("trust-store", AbstractHttpConnectorMigrationStep.TLS_NAMESPACE);
                XmlDslUtils.copyAttributeIfPresent((Element)tlsClient, (Element)keyStore, (String)"path");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsClient, (Element)keyStore, (String)"storePassword", (String)"password");
                if (tlsClient.getAttribute("class") != null) {
                    report.report("http.tlsClientClass", tlsClient, tlsClient, new String[0]);
                }
                XmlDslUtils.copyAttributeIfPresent((Element)tlsClient, (Element)keyStore, (String)"type", (String)"type");
                tlsContext.addContent((Content)keyStore);
                tlsConfigured = true;
            }
            if ((tlsKeyStore = httpsConnector.get().getChild("tls-key-store", AbstractHttpConnectorMigrationStep.HTTPS_NAMESPACE)) != null) {
                Element keyStore = new Element("key-store", AbstractHttpConnectorMigrationStep.TLS_NAMESPACE);
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"path");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"storePassword", (String)"password");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"keyPassword");
                if (tlsKeyStore.getAttribute("class") != null) {
                    report.report("http.tlsKeyStoreClass", tlsKeyStore, tlsKeyStore, new String[0]);
                }
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"type", (String)"type");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"keyAlias", (String)"alias");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"algorithm");
                tlsContext.addContent((Content)keyStore);
                tlsConfigured = true;
            }
            if (tlsConfigured) {
                appModel.addNameSpace(AbstractHttpConnectorMigrationStep.TLS_NAMESPACE.getPrefix(), AbstractHttpConnectorMigrationStep.TLS_NAMESPACE.getURI(), "http://www.mulesoft.org/schema/mule/tls/current/mule-tls.xsd");
                httpsRequesterConnection.addContent((Content)tlsContext);
            }
        }
    }

    @Override
    protected Element getConnector(String connectorName) {
        return this.getApplicationModel().getNode("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/https' and local-name()='connector' and @name = '" + connectorName + "']");
    }

    @Override
    protected Optional<Element> getDefaultConnector() {
        return this.getApplicationModel().getNodeOptional("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/https' and local-name()='connector']");
    }
}

