/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.json;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.json.JsonMigrationStep;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class JsonToObjectTransformer
extends AbstractApplicationModelMigrationStep
implements JsonMigrationStep {
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/json' and local-name()='json-to-object-transformer']";

    public String getDescription() {
        return "Migrate JSON to Object transformer";
    }

    public JsonToObjectTransformer() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{JSON_NAMESPACE}));
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        this.getApplicationModel();
        ApplicationModel.addNameSpace((Namespace)XmlDslUtils.CORE_EE_NAMESPACE, (String)"http://www.mulesoft.org/schema/mule/ee/core/current/mule-ee.xsd", (Document)element.getDocument());
        element.setName("transform");
        element.setNamespace(XmlDslUtils.CORE_EE_NAMESPACE);
        element.removeContent();
        element.addContent((Content)new Element("message", XmlDslUtils.CORE_EE_NAMESPACE).addContent((Content)new Element("set-payload", XmlDslUtils.CORE_EE_NAMESPACE).setText("%dw 2.0 output application/java --- payload" + (element.getAttributeValue("returnClass") != null ? " as Object { class: '" + element.getAttributeValue("returnClass") + "'}" : ""))));
        element.removeAttribute("mapper-ref");
        element.removeAttribute("returnClass");
        element.removeAttribute("name");
    }
}

