/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.salesforce;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.salesforce.AbstractSalesforceOperationMigrationStep;
import com.mulesoft.tools.migration.library.tools.SalesforceUtils;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.List;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class AbstractQueryOperationMigrationStep
extends AbstractSalesforceOperationMigrationStep {
    public AbstractQueryOperationMigrationStep(String m3Name, String m4Name) {
        super(m4Name);
        this.setAppliedTo(XmlDslUtils.getXPathSelector((String)"http://www.mulesoft.org/schema/mule/sfdc", (String)m3Name, (boolean)false));
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{SalesforceUtils.MULE3_SALESFORCE_NAMESPACE}));
    }

    @Override
    public void execute(Element mule3Operation, MigrationReport report) throws RuntimeException {
        super.execute(mule3Operation, report);
        this.resolveAttributes(mule3Operation, this.mule4Operation);
        XmlDslUtils.addElementAfter((Element)this.mule4Operation, (Element)mule3Operation);
        mule3Operation.getParentElement().removeContent((Content)mule3Operation);
    }

    protected void resolveAttributes(Element mule3Operation, Element mule4Operation) {
        String query = mule3Operation.getAttributeValue("query");
        if (query != null) {
            Element mule4Query = new Element("salesforce-query", SalesforceUtils.MULE4_SALESFORCE_NAMESPACE);
            String expression = this.expressionMigrator.migrateExpression(query, true, mule3Operation);
            mule4Query.setContent((Content)new CDATA(expression));
            mule4Operation.addContent((Content)mule4Query);
        }
    }

    protected void migrateHeadersWithFetchSize(Element mule3Operation, Element mule4Operation, MigrationReport report) {
        Element mule3Headers = mule3Operation.getChild("headers", SalesforceUtils.MULE3_SALESFORCE_NAMESPACE);
        String fetchSize = mule3Operation.getAttributeValue("fetchSize");
        report.report("salesforce.fetchSize", mule3Operation, mule4Operation, new String[0]);
        if (mule3Headers != null) {
            List children;
            String refHeaders = mule3Headers.getAttributeValue("ref");
            if (refHeaders != null) {
                String expression = this.expressionMigrator.migrateExpression(refHeaders, true, mule3Headers);
                String unwrappedExpression = this.expressionMigrator.unwrap(expression);
                expression = fetchSize != null ? this.expressionMigrator.wrap(unwrappedExpression + " ++ {'batchSize':\"" + fetchSize + "\"}") : this.expressionMigrator.wrap(unwrappedExpression + " ++ {'batchSize':\"2000\"}");
                mule4Operation.setAttribute("headers", expression);
            }
            if ((children = mule3Headers.getChildren()).size() > 0) {
                Element mule4Headers = new Element("headers", SalesforceUtils.MULE4_SALESFORCE_NAMESPACE);
                children.stream().forEach(header -> mule4Headers.addContent((Content)new Element("header", SalesforceUtils.MULE4_SALESFORCE_NAMESPACE).setAttribute("key", header.getAttributeValue("key")).setAttribute("value", header.getText())));
                mule4Operation.addContent((Content)mule4Headers);
                if (fetchSize != null) {
                    mule4Headers.addContent((Content)new Element("header", SalesforceUtils.MULE4_SALESFORCE_NAMESPACE).setAttribute("key", "batchSize").setAttribute("value", fetchSize));
                } else {
                    mule4Headers.addContent((Content)new Element("header", SalesforceUtils.MULE4_SALESFORCE_NAMESPACE).setAttribute("key", "batchSize").setAttribute("value", "2000"));
                }
            }
        } else if (fetchSize != null) {
            String expression = this.expressionMigrator.wrap("{'batchSize':\"" + fetchSize + "\"}");
            mule4Operation.setAttribute("headers", expression);
        } else {
            String expression = this.expressionMigrator.wrap("{'batchSize':\"2000\"}");
            mule4Operation.setAttribute("headers", expression);
        }
    }
}

