/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.salesforce;

import com.mulesoft.tools.migration.library.tools.SalesforceUtils;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class AbstractSalesforceSourcesMigrationStep
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    private final String mule3Name;
    private final String mule4Name;
    protected ExpressionMigrator expressionMigrator;
    protected Element mule4Source;

    public AbstractSalesforceSourcesMigrationStep(String mule3Name, String mule4Name) {
        this.mule3Name = mule3Name;
        this.mule4Name = mule4Name;
    }

    public void execute(Element mule3Source, MigrationReport report) throws RuntimeException {
        ApplicationModel.addNameSpace((Namespace)SalesforceUtils.MULE4_SALESFORCE_NAMESPACE, (String)"http://www.mulesoft.org/schema/mule/salesforce/current/mule-salesforce.xsd", (Document)mule3Source.getDocument());
        this.mule4Source = new Element(this.getMule4Name(), SalesforceUtils.MULE4_SALESFORCE_NAMESPACE);
        this.setDefaultAttributes(mule3Source, this.mule4Source);
    }

    private void setDefaultAttributes(Element mule3Source, Element mule4Source) {
        String configRef;
        String notes;
        String docName = mule3Source.getAttributeValue("name", SalesforceUtils.DOC_NAMESPACE);
        if (docName != null) {
            mule4Source.setAttribute("name", docName, SalesforceUtils.DOC_NAMESPACE);
        }
        if ((notes = mule3Source.getAttributeValue("description", SalesforceUtils.DOC_NAMESPACE)) != null) {
            mule4Source.setAttribute("description", notes, SalesforceUtils.DOC_NAMESPACE);
        }
        if ((configRef = mule3Source.getAttributeValue("config-ref")) != null && !configRef.isEmpty()) {
            mule4Source.setAttribute("config-ref", configRef);
        }
    }

    public String getMule4Name() {
        return this.mule4Name;
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

