/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.salesforce;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.salesforce.AbstractSalesforceOperationMigrationStep;
import com.mulesoft.tools.migration.library.tools.SalesforceUtils;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class UpdateOperation
extends AbstractSalesforceOperationMigrationStep
implements ExpressionMigratorAware {
    private static final String name = "update";

    public UpdateOperation() {
        super(name);
        this.setAppliedTo(XmlDslUtils.getXPathSelector((String)"http://www.mulesoft.org/schema/mule/sfdc", (String)name, (boolean)false));
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{SalesforceUtils.MULE3_SALESFORCE_NAMESPACE}));
    }

    @Override
    public void execute(Element mule3Operation, MigrationReport report) throws RuntimeException {
        super.execute(mule3Operation, report);
        ApplicationModel.addNameSpace((Namespace)XmlDslUtils.CORE_EE_NAMESPACE, (String)"http://www.mulesoft.org/schema/mule/ee/core/current/mule-ee.xsd", (Document)mule3Operation.getDocument());
        SalesforceUtils.resolveTypeAttribute(mule3Operation, this.mule4Operation);
        Optional<Element> objects = Optional.ofNullable(mule3Operation.getChild("objects", SalesforceUtils.MULE3_SALESFORCE_NAMESPACE));
        objects.ifPresent(records -> {
            SalesforceUtils.migrateRecordsFromExpression(records, this.mule4Operation, this.expressionMigrator, "records");
            List children = records.getChildren();
            if (children.size() > 0) {
                String transformBody = children.stream().map(object -> object.getChildren().stream().map(innerObject -> innerObject.getAttributeValue("key") + " : \"" + innerObject.getText() + "\"").collect(Collectors.joining(",\n"))).collect(Collectors.joining("\n},\n{"));
                SalesforceUtils.createTransformBeforeElement(mule3Operation, "%dw 2.0 output application/json\n---\n[{\n" + transformBody + "\n}]");
            }
        });
        XmlDslUtils.addElementAfter((Element)this.mule4Operation, (Element)mule3Operation);
        mule3Operation.getParentElement().removeContent((Content)mule3Operation);
        SalesforceUtils.createTransformAfterElementToMatchOutputs(this.mule4Operation, SalesforceUtils.getTransformBodyToMatchCreateAndUpdateOutputs());
        report.report("salesforce.outputMatch", this.mule4Operation, null, new String[0]);
    }
}

