/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.scripting;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.scripting.ScriptingModuleMigration;
import com.mulesoft.tools.migration.library.mule.steps.validation.ValidationMigration;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ScriptingFilterMigration
extends ScriptingModuleMigration {
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/scripting' and local-name()='filter']";

    public ScriptingFilterMigration() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{SCRIPT_NAMESPACE}));
    }

    @Override
    public String getDescription() {
        return "Update scripting filter.";
    }

    @Override
    public void execute(Element element, MigrationReport report) throws RuntimeException {
        super.execute(element, report);
        element.setAttribute("target", "filterAccepted");
        XmlDslUtils.addElementAfter((Element)new Element("is-true", ValidationMigration.VALIDATION_NAMESPACE).setAttribute("expression", "#[vars.filterAccepted]"), (Element)element);
        this.handleFilter(element);
    }

    @Override
    protected void handleCode(Element scriptNode) {
        XmlDslUtils.setText((Element)scriptNode, (String)scriptNode.getChild("text", SCRIPT_NAMESPACE).getText());
    }

    protected void handleFilter(Element filter) {
        Element flow;
        if (!(filter.getParentElement().getNamespace().equals((Object)ValidationMigration.VALIDATION_NAMESPACE) && filter.getParentElement().getName().endsWith("filter") || (flow = XmlDslUtils.getContainerElement((Element)filter)) == null)) {
            Element errorHandler = XmlDslUtils.getFlowExceptionHandlingElement((Element)flow);
            if (errorHandler == null) {
                errorHandler = new Element("error-handler", XmlDslUtils.CORE_NAMESPACE);
                flow.addContent((Content)errorHandler);
            }
            this.resolveValidationHandler(errorHandler);
        }
    }

    protected Element resolveValidationHandler(Element errorHandler) {
        return errorHandler.getChildren().stream().filter(c -> "on-error-propagate".equals(c.getName()) && "MULE:VALIDATION".equals(c.getAttributeValue("type"))).findFirst().orElseGet(() -> {
            Element validationHandler = new Element("on-error-propagate", XmlDslUtils.CORE_NAMESPACE).setAttribute("type", "MULE:VALIDATION").setAttribute("logException", "false");
            errorHandler.addContent(0, (Content)validationHandler);
            validationHandler.addContent((Content)new Element("set-variable", XmlDslUtils.CORE_NAMESPACE).setAttribute("variableName", "filtered").setAttribute("value", "#[true]"));
            return validationHandler;
        });
    }
}

