/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.scripting;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mulesoft.tools.migration.project.model.ApplicationModelUtils;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.util.ArrayList;
import java.util.HashMap;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ScriptingModuleMigration
extends AbstractApplicationModelMigrationStep {
    protected static final String SCRIPT_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/scripting";
    private static final String SCRIPT_NAMESPACE_PREFIX = "scripting";
    protected static final Namespace SCRIPT_NAMESPACE = Namespace.getNamespace((String)"scripting", (String)"http://www.mulesoft.org/schema/mule/scripting");
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/scripting' and local-name()='component']";

    public ScriptingModuleMigration() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{SCRIPT_NAMESPACE}));
    }

    public String getDescription() {
        return "Update scripting module.";
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        Element scriptNode;
        ApplicationModelUtils.changeNodeName((String)SCRIPT_NAMESPACE_PREFIX, (String)"execute").apply(element);
        Element element2 = scriptNode = element.getChildren("script", element.getNamespace()).size() > 0 ? (Element)element.getChildren("script", element.getNamespace()).get(0) : null;
        if (scriptNode != null) {
            ApplicationModelUtils.changeNodeName((String)SCRIPT_NAMESPACE_PREFIX, (String)"code").apply(scriptNode);
            Attribute attribute = scriptNode.getAttribute("engine");
            if (attribute != null) {
                attribute.setValue(this.updateEngineValue(attribute.getValue()).toLowerCase());
                scriptNode.removeAttribute(attribute);
                element.setAttribute(attribute);
            } else {
                element.setAttribute("engine", "groovy");
            }
            attribute = scriptNode.getAttribute("file");
            if (attribute != null) {
                scriptNode.addContent("${file::" + attribute.getValue() + "}");
                scriptNode.removeAttribute(attribute);
            } else {
                this.handleCode(scriptNode);
            }
            this.movePropertiesToMap(scriptNode);
        }
        element.removeAttribute("name");
        report.report("scripting.messageFormat", element, element, new String[0]);
    }

    protected void handleCode(Element scriptNode) {
    }

    private String updateEngineValue(String engine) {
        if (engine.equalsIgnoreCase("jruby")) {
            return "ruby";
        }
        if (engine.equalsIgnoreCase("javascript")) {
            return "nashorn";
        }
        return engine;
    }

    private void movePropertiesToMap(Element scriptNode) {
        HashMap scriptParameters = new HashMap();
        ArrayList childsToRemove = new ArrayList();
        if (scriptNode.getChildren().size() > 0) {
            scriptNode.getChildren().forEach(p -> {
                scriptParameters.put(p.getAttributeValue("key"), p.getAttributeValue("value"));
                childsToRemove.add(p);
            });
            childsToRemove.forEach(s -> s.getParent().removeContent((Content)s));
            Element parametersElement = new Element("parameters", scriptNode.getNamespace());
            Gson gson = new GsonBuilder().create();
            String jsonMap = gson.toJson(scriptParameters);
            parametersElement.addContent("#[" + jsonMap + "]");
            scriptNode.getParentElement().addContent((Content)parametersElement);
        }
    }
}

