/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.security.oauth2;

import com.mulesoft.tools.migration.library.mule.steps.http.AbstractHttpConnectorMigrationStep;
import com.mulesoft.tools.migration.library.mule.steps.http.HttpInboundEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.http.HttpsInboundEndpoint;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class OAuth2ProviderConfig
extends AbstractApplicationModelMigrationStep {
    public static final String OAUTH2_PROVIDER_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/oauth2-provider";
    public static final Namespace OAUTH2_PROVIDER_NAMESPACE = Namespace.getNamespace((String)"oauth2-provider", (String)"http://www.mulesoft.org/schema/mule/oauth2-provider");
    public static final String XPATH_SELECTOR = "/*/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/oauth2-provider' and local-name() = 'config']";

    public String getDescription() {
        return "Update oauth2 provider configuration.";
    }

    public OAuth2ProviderConfig() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Collections.singletonList(OAUTH2_PROVIDER_NAMESPACE));
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        String supportedGrantTypes;
        String defaultScopes;
        String scopes;
        this.getApplicationModel();
        ApplicationModel.addNameSpace((Namespace)OAUTH2_PROVIDER_NAMESPACE, (String)"http://www.mulesoft.org/schema/mule/oauth2-provider/current/mule-oauth2-provider.xsd", (Document)element.getDocument());
        if (element.getAttribute("preFlow-ref") != null) {
            report.report("oauth2Provider.preFlow", element, element, new String[0]);
            element.removeAttribute("preFlow-ref");
        }
        if (element.getAttribute("name") == null) {
            if (element.getAttribute("providerName") != null) {
                element.setAttribute("name", element.getAttributeValue("providerName").replaceAll(" ", "_"));
            } else {
                element.setAttribute("name", "oauth2ProviderConfig");
            }
        }
        if (element.getAttribute("clientStore-ref") != null) {
            this.getApplicationModel().getNodeOptional("//*[namespace-uri() = 'http://www.springframework.org/schema/beans' and local-name() = 'bean' and @name='" + element.getAttributeValue("clientStore-ref") + "']").ifPresent(b -> element.getAttribute("clientStore-ref").setValue(b.getAttributes().stream().filter(att -> "objectStore-ref".equals(att.getName())).map(att -> att.getValue()).findFirst().get()));
            element.getAttribute("clientStore-ref").setName("clientStore");
        }
        this.handleHttpListener(element, report);
        if (element.getAttribute("resourceOwnerSecurityProvider-ref") != null) {
            element.getAttribute("resourceOwnerSecurityProvider-ref").setName("resourceOwnerSecurityProvider");
        }
        if (element.getAttribute("clientSecurityProvider-ref") != null) {
            element.getAttribute("clientSecurityProvider-ref").setName("clientSecurityProvider");
        }
        if (element.getAttribute("tokenGeneratorStrategy-ref") != null) {
            element.getAttribute("tokenGeneratorStrategy-ref").setName("tokenGeneratorStrategy");
        }
        if ((scopes = element.getAttributeValue("scopes")) != null) {
            element.setAttribute("scopes", Arrays.stream(scopes.split(" ")).collect(Collectors.joining(",")));
        }
        if ((defaultScopes = element.getAttributeValue("defaultScopes")) != null) {
            element.setAttribute("defaultScopes", Arrays.stream(defaultScopes.split(" ")).collect(Collectors.joining(",")));
        }
        if ((supportedGrantTypes = element.getAttributeValue("supportedGrantTypes")) != null) {
            element.setAttribute("supportedGrantTypes", Arrays.stream(supportedGrantTypes.split(" ")).collect(Collectors.joining(",")));
        }
        if (element.getAttribute("rateLimiter-ref") != null) {
            this.migrateRateLimiter(element, report);
        }
        this.migrateTokenConfig(element, report);
        this.migrateAuthorizationConfig(element, report);
        this.migrateClients(element);
    }

    private void handleHttpListener(Element element, MigrationReport report) {
        if (element.getAttribute("listenerConfig-ref") != null) {
            element.getAttribute("listenerConfig-ref").setName("listenerConfig");
        } else if (element.getAttribute("connector-ref") != null) {
            String configName = element.getAttributeValue("connector-ref");
            String host = element.getAttributeValue("host");
            String port = element.getAttributeValue("port");
            Element httpConnector = this.getHttpConnector(element.getAttributeValue("connector-ref"));
            HttpInboundEndpoint.extractListenerConfig(this.getApplicationModel(), element, () -> httpConnector, AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE, configName, host != null ? host : "localhost", port != null ? port : "9999");
            this.getApplicationModel().addNameSpace("http", "http://www.mulesoft.org/schema/mule/http", "http://www.mulesoft.org/schema/mule/http/current/mule-http.xsd");
            if (AbstractHttpConnectorMigrationStep.HTTPS_NAMESPACE.equals((Object)httpConnector.getNamespace())) {
                HttpsInboundEndpoint.handleHttpsListenerConfig(this.getApplicationModel(), element, report, httpConnector);
            }
            element.removeAttribute("config-ref");
            element.getAttribute("connector-ref").setName("listenerConfig");
        } else {
            String httpListenerConfigName = element.getAttributeValue("name") + "_httpListenerConfig";
            element.setAttribute("listenerConfig", httpListenerConfigName);
            String host = element.getAttributeValue("host");
            String port = element.getAttributeValue("port");
            XmlDslUtils.addElementAfter((Element)new Element("listener-config", AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE).setAttribute("name", httpListenerConfigName).addContent((Content)new Element("listener-connection", AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE).setAttribute("host", host != null ? host : "localhost").setAttribute("port", port != null ? port : "9999")), (Element)element);
        }
        element.removeAttribute("host");
        element.removeAttribute("port");
    }

    private void migrateRateLimiter(Element element, MigrationReport report) {
        Element clientValidationRateLimiter = new Element("client-validation-rate-limiter", OAUTH2_PROVIDER_NAMESPACE);
        Element periodRateLimiter = new Element("period-rate-limiter", OAUTH2_PROVIDER_NAMESPACE);
        clientValidationRateLimiter.addContent((Content)periodRateLimiter);
        element.addContent((Content)clientValidationRateLimiter);
        this.getApplicationModel().getNodeOptional("//*[namespace-uri() = 'http://www.springframework.org/schema/beans' and local-name() = 'bean' and @name='" + element.getAttributeValue("rateLimiter-ref") + "']").ifPresent(b -> report.report("oauth2Provider.clientValidationRateLimiter", b, clientValidationRateLimiter, new String[0]));
        element.removeAttribute("rateLimiter-ref");
    }

    private void migrateTokenConfig(Element element, MigrationReport report) {
        Element tokenConfig = new Element("token-config", OAUTH2_PROVIDER_NAMESPACE);
        String path = element.getAttributeValue("accessTokenEndpointPath");
        if (path != null) {
            tokenConfig.setAttribute("path", path.startsWith("/") ? path : "/" + path);
            element.removeAttribute("accessTokenEndpointPath");
        }
        AtomicReference<Element> refreshTokens = new AtomicReference<Element>();
        if ("true".equals(element.getAttributeValue("enableRefreshToken"))) {
            if ("true".equals(element.getAttributeValue("issueNewRefreshToken"))) {
                refreshTokens.set(new Element("multiple-refresh-tokens", OAUTH2_PROVIDER_NAMESPACE));
            } else {
                refreshTokens.set(new Element("single-refresh-tokens", OAUTH2_PROVIDER_NAMESPACE));
            }
            element.removeAttribute("issueNewRefreshToken");
            tokenConfig.addContent((Content)new Element("refresh-token-strategy", OAUTH2_PROVIDER_NAMESPACE).addContent((Content)refreshTokens.get()));
            if (element.getAttributeValue("refreshTokenTtlSeconds") != null) {
                report.report("oauth2Provider.refreshTokenTtl", element, tokenConfig, new String[0]);
                element.removeAttribute("refreshTokenTtlSeconds");
            }
        }
        element.removeAttribute("enableRefreshToken");
        this.getApplicationModel().getNodeOptional("//*[namespace-uri() = 'http://www.springframework.org/schema/beans' and local-name() = 'bean' and @name='" + element.getAttributeValue("tokenStore-ref") + "']").ifPresent(b -> {
            tokenConfig.setAttribute("tokenStore", b.getAttributes().stream().filter(att -> "accessTokenObjectStore-ref".equals(att.getName())).map(att -> att.getValue()).findFirst().get());
            if (refreshTokens.get() != null) {
                ((Element)refreshTokens.get()).setAttribute("objectStore", b.getAttributes().stream().filter(att -> "refreshTokenObjectStore-ref".equals(att.getName())).map(att -> att.getValue()).findFirst().get());
            }
        });
        if (element.getAttributeValue("tokenStore-ref") != null) {
            element.removeAttribute("tokenStore-ref");
            if (element.getAttributeValue("tokenTtlSeconds") != null) {
                report.report("oauth2Provider.tokenTtl", element, tokenConfig, new String[0]);
                element.removeAttribute("tokenTtlSeconds");
            }
        }
        element.addContent((Content)tokenConfig);
    }

    private void migrateAuthorizationConfig(Element element, MigrationReport report) {
        String path;
        Element authorizationConfig = new Element("authorization-config", OAUTH2_PROVIDER_NAMESPACE);
        if (element.getAttributeValue("loginPage") != null) {
            authorizationConfig.setAttribute("loginPage", element.getAttributeValue("loginPage"));
            element.removeAttribute("loginPage");
        }
        if ((path = element.getAttributeValue("authorizationEndpointPath")) != null) {
            authorizationConfig.setAttribute("path", path.startsWith("/") ? path : "/" + path);
            element.removeAttribute("authorizationEndpointPath");
        }
        if (element.getAttributeValue("authorizationCodeStore-ref") != null) {
            this.getApplicationModel().getNodeOptional("//*[namespace-uri() = 'http://www.springframework.org/schema/beans' and local-name() = 'bean' and @name='" + element.getAttributeValue("authorizationCodeStore-ref") + "']").ifPresent(b -> authorizationConfig.setAttribute("authorizationCodeStore", b.getAttributes().stream().filter(att -> "objectStore-ref".equals(att.getName())).map(att -> att.getValue()).findFirst().get()));
            element.removeAttribute("authorizationCodeStore-ref");
            if (element.getAttributeValue("authorizationTtlSeconds") != null) {
                report.report("oauth2Provider.authorizationTtl", element, authorizationConfig, new String[0]);
                element.removeAttribute("authorizationTtlSeconds");
            }
        }
        element.addContent((Content)authorizationConfig);
    }

    private void migrateClients(Element element) {
        Element clients = element.getChild("clients", OAUTH2_PROVIDER_NAMESPACE);
        if (clients != null) {
            clients.detach();
            element.addContent((Content)clients);
            clients.getChildren("client", OAUTH2_PROVIDER_NAMESPACE).forEach(client -> {
                if (client.getChild("redirect-uris", OAUTH2_PROVIDER_NAMESPACE) != null) {
                    client.getChild("redirect-uris", OAUTH2_PROVIDER_NAMESPACE).setName("client-redirect-uris").getChildren("redirect-uri", OAUTH2_PROVIDER_NAMESPACE).forEach(redirectUri -> {
                        redirectUri.setAttribute("value", redirectUri.getTextTrim());
                        redirectUri.setName("client-redirect-uri");
                        redirectUri.removeContent();
                    });
                }
                if (client.getChild("authorized-grant-types", OAUTH2_PROVIDER_NAMESPACE) != null) {
                    client.getChild("authorized-grant-types", OAUTH2_PROVIDER_NAMESPACE).setName("client-authorized-grant-types").getChildren("authorized-grant-type", OAUTH2_PROVIDER_NAMESPACE).forEach(redirectUri -> {
                        redirectUri.setAttribute("value", redirectUri.getTextTrim());
                        redirectUri.setName("client-authorized-grant-type");
                        redirectUri.removeContent();
                    });
                }
                if (client.getChild("scopes", OAUTH2_PROVIDER_NAMESPACE) != null) {
                    client.getChild("scopes", OAUTH2_PROVIDER_NAMESPACE).setName("client-scopes").getChildren("scope", OAUTH2_PROVIDER_NAMESPACE).forEach(redirectUri -> {
                        redirectUri.setAttribute("value", redirectUri.getTextTrim());
                        redirectUri.setName("client-scope");
                        redirectUri.removeContent();
                    });
                }
            });
        }
    }

    protected Element getHttpConnector(String connectorName) {
        return this.getApplicationModel().getNodeOptional("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and local-name()='connector' and @name = '" + connectorName + "']").orElse(this.getApplicationModel().getNode("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/https' and local-name()='connector' and @name = '" + connectorName + "']"));
    }
}

