/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.security.oauth2;

import com.mulesoft.tools.migration.library.mule.steps.security.oauth2.OAuth2ProviderConfig;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import org.jdom2.Element;

public class OAuth2ProviderValidate
extends AbstractApplicationModelMigrationStep {
    public static final String XPATH_SELECTOR = "//*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/oauth2-provider' and local-name() = 'validate']";

    public String getDescription() {
        return "Update oauth2 provider validate operation.";
    }

    public OAuth2ProviderValidate() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Collections.singletonList(OAuth2ProviderConfig.OAUTH2_PROVIDER_NAMESPACE));
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        element.setName("validate-token");
        Element cfg = this.getApplicationModel().getNode("/*/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/oauth2-provider' and local-name() = 'config']");
        element.setAttribute("config-ref", cfg.getAttributeValue("name"));
        String scopes = element.getAttributeValue("scopes");
        if (scopes != null) {
            element.setAttribute("scopes", Arrays.stream(scopes.split(" ")).collect(Collectors.joining("', '", "#[['", "']]")));
        }
        if (element.getAttribute("throwExceptionOnUnaccepted") == null || element.getAttributeValue("throwExceptionOnUnaccepted").equals("false")) {
            report.report("filters.validationsRaiseError", element, element, new String[0]);
        }
        element.removeAttribute("throwExceptionOnUnaccepted");
    }
}

