/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.validation;

import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class ValidationI18NMigration
extends AbstractApplicationModelMigrationStep {
    private static final String VALIDATION_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/validation";
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/validation' and local-name()='i18-n-config']";

    public String getDescription() {
        return "Migrate I18-N Global Config";
    }

    public ValidationI18NMigration() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        Element parentElement = element.getParentElement();
        if (parentElement.getName().equals("config")) {
            element.setName("i18-n");
        } else {
            element.setName("config");
            Element childNode = new Element("i18n", element.getNamespace());
            XmlDslUtils.copyAttributeIfPresent((Element)element, (Element)childNode, (String)"bundlePath");
            XmlDslUtils.copyAttributeIfPresent((Element)element, (Element)childNode, (String)"locale");
            element.addContent((Content)childNode);
        }
    }
}

