/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.munit.steps;

import com.mulesoft.tools.migration.exception.MigrationStepException;
import com.mulesoft.tools.migration.library.munit.steps.AbstractAssertionMigration;
import com.mulesoft.tools.migration.project.model.ApplicationModelUtils;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.Optional;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class AssertPayload
extends AbstractAssertionMigration {
    private static final String XPATH_SELECTOR = XmlDslUtils.getXPathSelector((String)"http://www.mulesoft.org/schema/mule/munit", (String)"assert-payload-equals");

    public String getDescription() {
        return "Update Assert Payload-Equals to new MUnit Assertion component";
    }

    public AssertPayload() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        try {
            ApplicationModelUtils.changeNodeName((String)"munit-tools", (String)"assert-that").andThen(ApplicationModelUtils.addAttribute((String)"expression", (String)"#[payload]")).andThen(ApplicationModelUtils.changeAttribute((String)"expectedValue", Optional.of("is"), Optional.empty())).apply(element);
            Attribute isAttribute = element.getAttribute("is");
            if (isAttribute != null) {
                String attributeValue = isAttribute.getValue();
                attributeValue = this.getExpressionMigrator().isWrapped(attributeValue) ? "#[MunitTools::equalTo(" + this.getExpressionMigrator().unwrap(attributeValue) + ")]" : "#[MunitTools::equalTo(" + attributeValue + ")]";
                isAttribute.setValue(attributeValue);
            }
        }
        catch (Exception e) {
            throw new MigrationStepException("Fail to apply step. " + e.getMessage());
        }
    }
}

