/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.munit.steps;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.tools.PluginsVersions;
import com.mulesoft.tools.migration.project.model.pom.Dependency;
import com.mulesoft.tools.migration.project.model.pom.Plugin;
import com.mulesoft.tools.migration.project.model.pom.PluginExecution;
import com.mulesoft.tools.migration.project.model.pom.PomModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.category.PomContribution;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class MUnitPomContribution
implements PomContribution {
    private static final String MUNIT_MAVEN_PLUGIN_GROUP_ID = "com.mulesoft.munit.tools";
    private static final String MUNIT_MAVEN_PLUGIN_ARTIFACT_ID = "munit-maven-plugin";
    private static final String MUNIT_SUPPORT_PROPERTY = "mule.munit.support.version";
    private static final String MUNIT_PROPERTY = "munit.version";

    public String getDescription() {
        return "Add MUnit dependencies.";
    }

    public void execute(PomModel pomModel, MigrationReport report) throws RuntimeException {
        pomModel.addDependency(new Dependency.DependencyBuilder().withGroupId("com.mulesoft.munit").withArtifactId("munit-runner").withVersion(PluginsVersions.targetVersion(MUNIT_MAVEN_PLUGIN_ARTIFACT_ID)).withClassifier("mule-plugin").withScope("test").build());
        pomModel.addDependency(new Dependency.DependencyBuilder().withGroupId("com.mulesoft.munit").withArtifactId("munit-tools").withVersion(PluginsVersions.targetVersion(MUNIT_MAVEN_PLUGIN_ARTIFACT_ID)).withClassifier("mule-plugin").withScope("test").build());
        if (!this.getMUnitPlugin(pomModel).isEmpty()) {
            Plugin munitPlugin = this.getMUnitPlugin(pomModel).get(0);
            munitPlugin.setVersion(PluginsVersions.targetVersion(MUNIT_MAVEN_PLUGIN_ARTIFACT_ID));
        } else {
            pomModel.addPlugin(this.buildMunitPlugin());
        }
        pomModel.removeProperty(MUNIT_SUPPORT_PROPERTY);
        pomModel.removeProperty(MUNIT_PROPERTY);
        pomModel.addProperty(MUNIT_PROPERTY, PluginsVersions.targetVersion(MUNIT_MAVEN_PLUGIN_ARTIFACT_ID));
    }

    private List<Plugin> getMUnitPlugin(PomModel pomModel) {
        return pomModel.getPlugins().stream().filter(p -> StringUtils.equals((CharSequence)p.getArtifactId(), (CharSequence)MUNIT_MAVEN_PLUGIN_ARTIFACT_ID)).collect(Collectors.toList());
    }

    private Plugin buildMunitPlugin() {
        ArrayList<PluginExecution> pluginExecutions = new ArrayList<PluginExecution>();
        pluginExecutions.add(new PluginExecution.PluginExecutionBuilder().withId("test").withGoals((List)Lists.newArrayList((Object[])new String[]{"test", "coverage-report"})).withPhase("test").build());
        return new Plugin.PluginBuilder().withGroupId(MUNIT_MAVEN_PLUGIN_GROUP_ID).withArtifactId(MUNIT_MAVEN_PLUGIN_ARTIFACT_ID).withVersion(PluginsVersions.targetVersion(MUNIT_MAVEN_PLUGIN_ARTIFACT_ID)).withExecutions(pluginExecutions).build();
    }
}

