/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.munit.steps;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.exception.MigrationStepException;
import com.mulesoft.tools.migration.project.model.ApplicationModelUtils;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.util.List;
import java.util.Optional;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class Mock
extends AbstractApplicationModelMigrationStep {
    private static final String MOCK_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/mock";
    private static final String MOCK_NAMESPACE_PREFIX = "mock";
    private static final Namespace MOCK_NAMESPACE = Namespace.getNamespace((String)"mock", (String)"http://www.mulesoft.org/schema/mule/mock");
    private static final String MUNIT_TOOLS_PREFIX = "munit-tools";
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/mock' and local-name()='when']";

    public String getDescription() {
        return "Update MUnit Mock component";
    }

    public Mock() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{MOCK_NAMESPACE}));
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        try {
            ApplicationModelUtils.changeNodeName((String)MUNIT_TOOLS_PREFIX, (String)"mock-when").andThen(ApplicationModelUtils.changeAttribute((String)"messageProcessor", Optional.of("processor"), Optional.empty())).apply(element);
            this.updateChildElementsNamespace(element.getChildren());
            Element attributesNode = element.getChild("with-attributes", element.getNamespace());
            attributesNode.getChildren().forEach(n -> {
                Element cfr_ignored_0 = (Element)ApplicationModelUtils.changeAttribute((String)"name", Optional.of("attributeName"), Optional.empty()).apply(n);
            });
            this.movePayloadToChildNode(element.getChild("then-return", element.getNamespace()));
        }
        catch (Exception e) {
            throw new MigrationStepException("Fail to apply step. " + e.getMessage());
        }
    }

    private void movePayloadToChildNode(Element element) {
        ApplicationModelUtils.attributeToChildNode((String)"payload").apply(element);
        ApplicationModelUtils.moveAttributeToChildNode((String)"encoding", (String)"payload").andThen(ApplicationModelUtils.moveAttributeToChildNode((String)"mimeType", (String)"payload")).apply(element);
        ApplicationModelUtils.changeAttribute((String)"mimeType", Optional.of("mediaType"), Optional.empty()).apply(element.getChild("payload", element.getNamespace()));
    }

    private void updateChildElementsNamespace(List<Element> childs) {
        childs.forEach(c -> {
            c.setNamespace(c.getDocument().getRootElement().getNamespace(MUNIT_TOOLS_PREFIX));
            this.updateChildElementsNamespace(c.getChildren());
        });
    }
}

