/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.soapkit.helpers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

public class DocumentHelper {
    public static Document getDocument(String path) throws Exception {
        SAXBuilder saxBuilder = new SAXBuilder();
        File file = new File(path);
        return saxBuilder.build(file);
    }

    public static List<Element> getElementsFromDocument(Document doc, String xPathExpression) {
        try {
            return DocumentHelper.getElementsFromDocument(doc, xPathExpression, "mule");
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().matches("Namespace with prefix '\\w+' has not been declared.")) {
                return Collections.emptyList();
            }
            throw e;
        }
    }

    public static List<Element> getElementsFromDocument(Document doc, String xPathExpression, String defaultNamespacePrefix) {
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        namespaces.addAll(doc.getRootElement().getAdditionalNamespaces());
        if (namespaces.stream().noneMatch(n -> defaultNamespacePrefix.equals(n.getPrefix()))) {
            namespaces.add(Namespace.getNamespace((String)defaultNamespacePrefix, (String)doc.getRootElement().getNamespace().getURI()));
        }
        XPathExpression xpath = XPathFactory.instance().compile(xPathExpression, Filters.element(), null, namespaces);
        List nodes = xpath.evaluate((Object)doc);
        return nodes;
    }

    public static void renameAttribute(Element element, String attributeName, String newName) {
        Attribute attribute = element.getAttribute(attributeName);
        if (attribute != null) {
            element.setAttribute(newName, attribute.getValue());
            element.removeAttribute(attribute);
        }
    }

    public static void replaceAttributeValue(Element element, String attributeName, Function<String, String> f) {
        Attribute attribute = element.getAttribute(attributeName);
        if (attribute != null) {
            String value = attribute.getValue();
            value = f.apply(value);
            attribute.setValue(value);
        }
    }

    public static void replaceSlashesByBackSlashes(Element element, String attributeName) {
        DocumentHelper.replaceAttributeValue(element, attributeName, value -> value.replaceAll("/", "\\\\"));
    }

    public static void addElement(Element element, String name, String text) {
        Namespace namespace = element.getNamespace();
        Element child = new Element(name, namespace);
        child.setText(text);
        element.addContent((Content)child);
    }
}

