/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.engine;

import com.google.common.base.Preconditions;
import com.mulesoft.tools.migration.Executable;
import com.mulesoft.tools.migration.engine.MigrationTaskLocator;
import com.mulesoft.tools.migration.engine.exception.MigrationJobException;
import com.mulesoft.tools.migration.engine.project.MuleProjectFactory;
import com.mulesoft.tools.migration.engine.project.ProjectTypeFactory;
import com.mulesoft.tools.migration.engine.project.structure.ApplicationPersister;
import com.mulesoft.tools.migration.engine.project.structure.BasicProject;
import com.mulesoft.tools.migration.engine.project.structure.mule.MuleProject;
import com.mulesoft.tools.migration.engine.project.structure.mule.four.MuleFourApplication;
import com.mulesoft.tools.migration.engine.project.structure.mule.four.MuleFourDomain;
import com.mulesoft.tools.migration.engine.project.structure.mule.four.MuleFourPolicy;
import com.mulesoft.tools.migration.exception.MigrationTaskException;
import com.mulesoft.tools.migration.library.tools.MelToDwExpressionMigrator;
import com.mulesoft.tools.migration.project.ProjectType;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.report.html.HTMLReport;
import com.mulesoft.tools.migration.report.html.model.ReportEntryModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.task.AbstractMigrationTask;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import com.mulesoft.tools.migration.util.version.VersionUtils;
import com.mulesoft.tools.migration.xml.AdditionalNamespacesFactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationJob
implements Executable {
    private static final String HTML_REPORT_FOLDER = "report";
    private transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Path project;
    private final Path parentDomainProject;
    private final Path outputProject;
    private final Path reportPath;
    private final List<AbstractMigrationTask> migrationTasks;
    private final String muleVersion;
    private String runnerVersion;

    private MigrationJob(Path project, Path parentDomainProject, Path outputProject, List<AbstractMigrationTask> migrationTasks, String muleVersion) {
        this.migrationTasks = migrationTasks;
        this.muleVersion = muleVersion;
        this.outputProject = outputProject;
        this.project = project;
        this.parentDomainProject = parentDomainProject;
        this.reportPath = outputProject.resolve(HTML_REPORT_FOLDER);
        this.runnerVersion = this.getClass().getPackage().getImplementationVersion();
        if (this.runnerVersion == null) {
            this.runnerVersion = "n/a";
        }
    }

    public void execute(MigrationReport report) throws Exception {
        ApplicationModel applicationModel = this.generateSourceApplicationModel(this.project);
        report.initialize(applicationModel.getProjectType(), this.project.getFileName().toString());
        Path sourceProjectBasePath = applicationModel.getProjectBasePath();
        this.persistApplicationModel(applicationModel);
        ProjectType targetProjectType = applicationModel.getProjectType().getTargetType();
        applicationModel = this.generateTargetApplicationModel(this.outputProject, targetProjectType, sourceProjectBasePath);
        for (AbstractMigrationTask task : this.migrationTasks) {
            if (!task.getApplicableProjectTypes().contains(targetProjectType)) continue;
            task.setApplicationModel(applicationModel);
            task.setExpressionMigrator((ExpressionMigrator)new MelToDwExpressionMigrator(report, applicationModel));
            try {
                task.execute(report);
                this.persistApplicationModel(applicationModel);
                applicationModel = this.generateTargetApplicationModel(this.outputProject, targetProjectType, sourceProjectBasePath);
            }
            catch (MigrationTaskException ex) {
                this.logger.error("Failed to apply task, rolling back and continuing with the next one.", (Throwable)ex);
            }
            catch (Exception e) {
                throw new MigrationJobException("Failed to continue executing migration: " + e.getClass().getName() + ": " + e.getMessage(), e);
            }
        }
        this.generateReport(report);
    }

    private void persistApplicationModel(ApplicationModel applicationModel) throws Exception {
        ApplicationPersister persister = new ApplicationPersister(applicationModel, this.outputProject);
        persister.persist();
    }

    private ApplicationModel generateSourceApplicationModel(Path project) throws Exception {
        ProjectTypeFactory projectFactory = new ProjectTypeFactory();
        ProjectType type = projectFactory.getProjectType(project);
        MuleProject muleProject = MuleProjectFactory.getMuleProject(project, type);
        ApplicationModel.ApplicationModelBuilder builder = new ApplicationModel.ApplicationModelBuilder().withConfigurationFiles(BasicProject.getFiles(muleProject.srcMainConfiguration(), "xml")).withProjectType(type).withMuleVersion(this.muleVersion).withPom(muleProject.pom()).withProjectBasePath(muleProject.getBaseFolder()).withSupportedNamespaces(AdditionalNamespacesFactory.getTasksDeclaredNamespaces(this.migrationTasks));
        if (muleProject.srcTestConfiguration().toFile().exists()) {
            builder.withTestConfigurationFiles(BasicProject.getFiles(muleProject.srcTestConfiguration(), "xml"));
        }
        return builder.build();
    }

    private ApplicationModel generateTargetApplicationModel(Path project, ProjectType type, Path sourceProjectBasePath) throws Exception {
        ApplicationModel.ApplicationModelBuilder appModelBuilder = new ApplicationModel.ApplicationModelBuilder().withMuleVersion(this.muleVersion).withSupportedNamespaces(AdditionalNamespacesFactory.getTasksDeclaredNamespaces(this.migrationTasks)).withSourceProjectBasePath(sourceProjectBasePath);
        if (type.equals((Object)ProjectType.MULE_FOUR_APPLICATION)) {
            MuleFourApplication application = new MuleFourApplication(project);
            return appModelBuilder.withConfigurationFiles(BasicProject.getFiles(application.srcMainConfiguration(), "xml")).withTestConfigurationFiles(BasicProject.getFiles(application.srcTestConfiguration(), "xml")).withMuleArtifactJson(application.muleArtifactJson()).withProjectBasePath(application.getBaseFolder()).withParentDomainBasePath(this.parentDomainProject).withPom(application.pom()).build();
        }
        if (type.equals((Object)ProjectType.MULE_FOUR_DOMAIN)) {
            MuleFourDomain domain = new MuleFourDomain(project);
            return appModelBuilder.withConfigurationFiles(BasicProject.getFiles(domain.srcMainConfiguration(), "xml")).withMuleArtifactJson(domain.muleArtifactJson()).withProjectBasePath(domain.getBaseFolder()).withPom(domain.pom()).build();
        }
        if (type.equals((Object)ProjectType.MULE_FOUR_POLICY)) {
            MuleFourPolicy policy = new MuleFourPolicy(project);
            return appModelBuilder.withConfigurationFiles(BasicProject.getFiles(policy.srcMainConfiguration(), "xml")).withMuleArtifactJson(policy.muleArtifactJson()).withProjectBasePath(policy.getBaseFolder()).withPom(policy.pom()).build();
        }
        throw new MigrationJobException("Undetermined project type");
    }

    private void generateReport(MigrationReport report) throws Exception {
        List reportEntries = report.getReportEntries();
        for (ReportEntryModel entry : reportEntries) {
            try {
                entry.setElementLocation();
            }
            catch (Exception ex) {
                throw new MigrationJobException("Failed to generate report.", ex);
            }
        }
        HTMLReport htmlReport = new HTMLReport(report.getReportEntries(), this.reportPath.toFile(), this.getRunnerVersion());
        htmlReport.printReport();
    }

    public Path getReportPath() {
        return this.reportPath;
    }

    public String getRunnerVersion() {
        return this.runnerVersion;
    }

    public static class MigrationJobBuilder {
        private Path project;
        private Path parentDomainProject;
        private Path outputProject;
        private String inputVersion;
        private String outputVersion;
        private List<AbstractMigrationTask> migrationTasks = new ArrayList<AbstractMigrationTask>();

        public MigrationJobBuilder withProject(Path project) {
            this.project = project;
            return this;
        }

        public MigrationJobBuilder withParentDomainProject(Path parentDomainProject) {
            this.parentDomainProject = parentDomainProject;
            return this;
        }

        public MigrationJobBuilder withOutputProject(Path outputProject) {
            this.outputProject = outputProject;
            return this;
        }

        public MigrationJobBuilder withInputVersion(String inputVersion) {
            this.inputVersion = inputVersion;
            return this;
        }

        public MigrationJobBuilder withOuputVersion(String outputVersion) {
            this.outputVersion = outputVersion;
            return this;
        }

        public MigrationJob build() throws Exception {
            Preconditions.checkState((this.project != null ? 1 : 0) != 0, (Object)"The project must not be null");
            if (!this.project.toFile().exists()) {
                throw new MigrationJobException("`projectBasePath` " + this.project.toString() + " does not exist");
            }
            if (!this.project.toFile().isDirectory()) {
                throw new MigrationJobException("`projectBasePath` " + this.project.toString() + " is not a directory");
            }
            if (this.parentDomainProject != null) {
                if (!this.parentDomainProject.toFile().exists()) {
                    throw new MigrationJobException("`parentDomainBasePath` " + this.project.toString() + " does not exist");
                }
                if (!this.parentDomainProject.toFile().isDirectory()) {
                    throw new MigrationJobException("`parentDomainBasePath` " + this.project.toString() + " is not a directory");
                }
            }
            Preconditions.checkState((this.inputVersion != null ? 1 : 0) != 0, (Object)"The input version must not be null");
            Preconditions.checkState((this.outputVersion != null ? 1 : 0) != 0, (Object)"The output version must not be null");
            if (!VersionUtils.isVersionValid((String)this.outputVersion, (String)"4.1.1").booleanValue()) {
                throw new MigrationJobException("Output Version " + this.outputVersion + " does not comply with semantic versioning specification");
            }
            Preconditions.checkState((this.outputProject != null ? 1 : 0) != 0, (Object)"The output project must not be null");
            if (this.outputProject.toFile().exists()) {
                throw new MigrationJobException("Destination folder already exist.");
            }
            MigrationTaskLocator migrationTaskLocator = new MigrationTaskLocator(this.inputVersion, this.outputVersion);
            this.migrationTasks = migrationTaskLocator.locate();
            return new MigrationJob(this.project, this.parentDomainProject, this.outputProject, this.migrationTasks, this.outputVersion.toString());
        }
    }
}

