/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.engine.project.structure;

import com.mulesoft.tools.migration.engine.exception.MigrationJobException;
import com.mulesoft.tools.migration.engine.project.ProjectMatcher;
import com.mulesoft.tools.migration.engine.project.ProjectTypeFactory;
import com.mulesoft.tools.migration.engine.project.structure.BasicProject;
import com.mulesoft.tools.migration.engine.project.structure.MavenProject;
import com.mulesoft.tools.migration.engine.project.structure.mule.MuleProject;
import com.mulesoft.tools.migration.engine.project.structure.mule.four.MuleFourApplication;
import com.mulesoft.tools.migration.engine.project.structure.mule.four.MuleFourDomain;
import com.mulesoft.tools.migration.engine.project.structure.mule.four.MuleFourPolicy;
import com.mulesoft.tools.migration.engine.project.structure.mule.three.MuleThreeApplication;
import com.mulesoft.tools.migration.engine.project.structure.mule.three.MuleThreeDomain;
import com.mulesoft.tools.migration.engine.project.structure.util.CopyFileVisitor;
import com.mulesoft.tools.migration.project.ProjectType;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.project.model.artifact.MuleArtifactJsonModel;
import com.mulesoft.tools.migration.project.model.pom.PomModel;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Text;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.LineSeparator;
import org.jdom2.output.XMLOutputter;

public class ApplicationPersister {
    private static ProjectTypeFactory projectFactory = new ProjectTypeFactory();
    private ApplicationModel appModel;
    private Path outputAppPath;
    private BasicProject projectOutput;
    private ProjectType projectType;

    public ApplicationPersister(ApplicationModel appModel, Path outputAppPath) throws Exception {
        this.setAppModel(appModel);
        this.setOutputAppPath(outputAppPath);
        this.setProjectType(projectFactory.getProjectType(appModel.getProjectBasePath()));
    }

    private void setProjectType(ProjectType projectType) {
        this.projectType = projectType;
    }

    private void setAppModel(ApplicationModel appModel) {
        this.appModel = appModel;
    }

    private void setOutputAppPath(Path outputAppPath) {
        this.outputAppPath = outputAppPath;
    }

    public void persist() throws Exception {
        this.projectOutput = ProjectMatcher.getProjectDestination(this.outputAppPath, this.projectType);
        if (this.baseFolderIsEmpty(this.outputAppPath)) {
            this.copyBaseProjectStructure();
        }
        if (this.projectOutput instanceof MuleProject) {
            this.createSourcesFolders();
            this.persistConfigFiles();
            this.persistMuleArtifactJson();
            this.persistPom();
            this.persistMuleAppProperties();
        }
    }

    private void persistMuleAppProperties() throws Exception {
        MuleThreeApplication project;
        Path source;
        this.projectType = projectFactory.getProjectType(this.appModel.getProjectBasePath());
        if ((this.projectType.equals((Object)ProjectType.MULE_THREE_APPLICATION) || this.projectType.equals((Object)ProjectType.MULE_THREE_MAVEN_APPLICATION)) && (source = (project = new MuleThreeApplication(this.appModel.getProjectBasePath())).appProperties()).toFile().exists()) {
            Path resources = ((MuleProject)this.projectOutput).srcMainResources();
            resources.toFile().mkdirs();
            Files.copy(source, resources.resolve("mule-app.properties"), new CopyOption[0]);
        }
    }

    private void persistConfigFiles() throws Exception {
        for (Map.Entry entry : this.appModel.getApplicationDocuments().entrySet()) {
            Path originalFilePath = (Path)entry.getKey();
            Path targetFilePath = this.getTargetFilePath(originalFilePath);
            Document document = (Document)entry.getValue();
            XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat().setIndent("    "));
            ByteArrayOutputStream preFromattedOutput = new ByteArrayOutputStream();
            xmlOutputter.output(document, (OutputStream)preFromattedOutput);
            SAXBuilder saxBuilder = new SAXBuilder();
            Document finalDocument = saxBuilder.build((InputStream)new ByteArrayInputStream(preFromattedOutput.toByteArray()));
            new LinkedList(finalDocument.getRootElement().getChildren()).descendingIterator().forEachRemaining(c -> {
                finalDocument.getRootElement().addContent(finalDocument.getRootElement().indexOf((Content)c) + 1, (Content)new Text(LineSeparator.NL.value()));
                if ("flow".equals(c.getName())) {
                    new LinkedList(c.getChildren()).descendingIterator().forEachRemaining(fc -> c.addContent(c.indexOf((Content)fc) + 1, (Content)new Text(LineSeparator.NL.value())));
                }
            });
            finalDocument.getRootElement().addContent(0, (Content)new Text(LineSeparator.NL.value()));
            File targetFile = targetFilePath.toFile();
            targetFile.getParentFile().mkdirs();
            new XMLOutputter().output(finalDocument, (OutputStream)new FileOutputStream(targetFile));
        }
    }

    private Path getTargetFilePath(Path originalFilePath) throws MigrationJobException {
        if (originalFilePath.toString().startsWith(MuleThreeApplication.srcMainConfigurationPath)) {
            return this.outputAppPath.resolve(((MuleProject)this.projectOutput).srcMainConfiguration()).resolve(originalFilePath.toString().substring(MuleThreeApplication.srcMainConfigurationPath.length() + 1));
        }
        if (originalFilePath.toString().startsWith(MuleThreeApplication.srcTestsConfigurationPath)) {
            return this.outputAppPath.resolve(((MuleProject)this.projectOutput).srcTestConfiguration()).resolve(originalFilePath.toString().substring(MuleThreeApplication.srcTestsConfigurationPath.length() + 1));
        }
        if (originalFilePath.toString().startsWith(MuleFourApplication.srcMainConfigurationPath)) {
            return this.outputAppPath.resolve(((MuleProject)this.projectOutput).srcMainConfiguration()).resolve(originalFilePath.toString().substring(MuleFourApplication.srcMainConfigurationPath.length() + 1));
        }
        if (originalFilePath.toString().startsWith(MuleThreeDomain.srcMainConfigurationPath)) {
            return this.outputAppPath.resolve(((MuleProject)this.projectOutput).srcMainConfiguration()).resolve(originalFilePath.toString().substring(MuleThreeDomain.srcMainConfigurationPath.length() + 1));
        }
        if (originalFilePath.toString().startsWith(MuleFourDomain.srcMainConfigurationPath)) {
            return this.outputAppPath.resolve(((MuleProject)this.projectOutput).srcMainConfiguration()).resolve(originalFilePath.toString().substring(MuleFourDomain.srcMainConfigurationPath.length() + 1));
        }
        if (this.projectOutput instanceof MuleFourPolicy) {
            try {
                FileUtils.moveFileToDirectory((File)this.outputAppPath.resolve(originalFilePath).toFile(), (File)((MuleProject)this.projectOutput).srcMainConfiguration().toFile(), (boolean)true);
            }
            catch (IOException e) {
                throw new MigrationJobException("Cannot create policy structure", e);
            }
            return this.outputAppPath.resolve(((MuleProject)this.projectOutput).srcMainConfiguration()).resolve(originalFilePath.toString());
        }
        if (originalFilePath.toString().startsWith(MuleFourApplication.srcMainResourcesPath)) {
            return this.outputAppPath.resolve(originalFilePath);
        }
        return this.outputAppPath.resolve(((MuleProject)this.projectOutput).srcTestConfiguration()).resolve(originalFilePath.getFileName().toString());
    }

    private void persistMuleArtifactJson() throws IOException {
        Optional muleArtifactJsonModel = this.appModel.getMuleArtifactJsonModel();
        if (muleArtifactJsonModel.isPresent() && this.projectOutput instanceof MuleFourApplication) {
            String jsonContent = ((MuleArtifactJsonModel)this.appModel.getMuleArtifactJsonModel().get()).toString();
            File outputFile = ((MuleFourApplication)this.projectOutput).muleArtifactJson().toFile();
            try (FileWriter fileWriter = new FileWriter(outputFile);){
                fileWriter.write(jsonContent);
            }
        }
    }

    private void copyBaseProjectStructure() throws IOException {
        CopyFileVisitor vistor = new CopyFileVisitor(this.appModel.getProjectBasePath().toFile(), this.outputAppPath.toFile());
        Files.walkFileTree(this.appModel.getProjectBasePath(), vistor);
    }

    private void createSourcesFolders() {
        File app;
        MuleProject project = (MuleProject)this.projectOutput;
        if (!Files.exists(project.srcMainConfiguration(), new LinkOption[0])) {
            app = project.srcMainConfiguration().toFile();
            app.mkdirs();
        }
        if (!(project instanceof MuleFourDomain || project instanceof MuleFourPolicy || Files.exists(project.srcTestConfiguration(), new LinkOption[0]))) {
            app = project.srcTestConfiguration().toFile();
            app.mkdirs();
        }
    }

    private boolean baseFolderIsEmpty(Path project) {
        File app = project.toFile();
        return app.list().length <= 0;
    }

    private void persistPom() throws Exception {
        MavenXpp3Writer mavenWriter = new MavenXpp3Writer();
        Path pomLocation = ((MavenProject)this.projectOutput).pom();
        BufferedWriter writer = new BufferedWriter(new FileWriter(pomLocation.toFile()));
        if (this.appModel.getPomModel().isPresent()) {
            mavenWriter.write((Writer)writer, ((PomModel)this.appModel.getPomModel().get()).getMavenModelCopy());
        }
    }
}

