/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.report.html.model;

import com.mulesoft.tools.migration.report.html.model.ReportEntryModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ApplicationReport {
    private Map<String, Map<String, List<ReportEntryModel>>> errorEntries = new HashMap<String, Map<String, List<ReportEntryModel>>>();
    private Map<String, Map<String, List<ReportEntryModel>>> warningEntries = new HashMap<String, Map<String, List<ReportEntryModel>>>();
    private Map<String, Map<String, List<ReportEntryModel>>> infoEntries = new HashMap<String, Map<String, List<ReportEntryModel>>>();

    protected ApplicationReport(Map<String, Map<String, List<ReportEntryModel>>> errorEntries, Map<String, Map<String, List<ReportEntryModel>>> warningEntries, Map<String, Map<String, List<ReportEntryModel>>> infoEntries) {
        this.errorEntries = errorEntries;
        this.warningEntries = warningEntries;
        this.infoEntries = infoEntries;
    }

    public Map<String, Map<String, List<ReportEntryModel>>> getErrorEntries() {
        return this.errorEntries;
    }

    public Map<String, Map<String, List<ReportEntryModel>>> getWarningEntries() {
        return this.warningEntries;
    }

    public Map<String, Map<String, List<ReportEntryModel>>> getInfoEntries() {
        return this.infoEntries;
    }

    public Map<String, Integer> getSummaryErrorEntries() {
        HashMap<String, Integer> summaryErrorEntries = new HashMap<String, Integer>();
        Integer issuesCount = 0;
        for (Map.Entry<String, Map<String, List<ReportEntryModel>>> entry : this.errorEntries.entrySet()) {
            for (Map.Entry<String, List<ReportEntryModel>> e : entry.getValue().entrySet()) {
                issuesCount = issuesCount + e.getValue().size();
            }
            summaryErrorEntries.put(entry.getKey(), issuesCount);
            issuesCount = 0;
        }
        return summaryErrorEntries;
    }

    public Map<String, Integer> getSummaryWarningEntries() {
        HashMap<String, Integer> summaryWarningEntries = new HashMap<String, Integer>();
        Integer issuesCount = 0;
        for (Map.Entry<String, Map<String, List<ReportEntryModel>>> entry : this.warningEntries.entrySet()) {
            for (Map.Entry<String, List<ReportEntryModel>> e : entry.getValue().entrySet()) {
                issuesCount = issuesCount + e.getValue().size();
            }
            summaryWarningEntries.put(entry.getKey(), issuesCount);
            issuesCount = 0;
        }
        return summaryWarningEntries;
    }

    public Map<String, Integer> getSummaryInfoEntries() {
        HashMap<String, Integer> summaryWarningEntries = new HashMap<String, Integer>();
        Integer issuesCount = 0;
        for (Map.Entry<String, Map<String, List<ReportEntryModel>>> entry : this.infoEntries.entrySet()) {
            for (Map.Entry<String, List<ReportEntryModel>> e : entry.getValue().entrySet()) {
                issuesCount = issuesCount + e.getValue().size();
            }
            summaryWarningEntries.put(entry.getKey(), issuesCount);
            issuesCount = 0;
        }
        return summaryWarningEntries;
    }

    public static class ApplicationReportBuilder {
        private List<ReportEntryModel> reportEntries;

        public ApplicationReportBuilder withReportEntries(List<ReportEntryModel> reportEntries) {
            this.reportEntries = reportEntries;
            return this;
        }

        public ApplicationReport build() {
            Map<String, Map<String, List<ReportEntryModel>>> errorEntries = this.getEntries(MigrationReport.Level.ERROR);
            Map<String, Map<String, List<ReportEntryModel>>> warningEntries = this.getEntries(MigrationReport.Level.WARN);
            Map<String, Map<String, List<ReportEntryModel>>> infoEntries = this.getEntries(MigrationReport.Level.INFO);
            return new ApplicationReport(errorEntries, warningEntries, infoEntries);
        }

        private Map<String, Map<String, List<ReportEntryModel>>> getEntries(MigrationReport.Level level) {
            HashMap<String, Map<String, List<ReportEntryModel>>> resources = new HashMap<String, Map<String, List<ReportEntryModel>>>();
            this.reportEntries.forEach(e -> {
                if (e.getLevel().equals((Object)level)) {
                    String fileName = e.getFilePath() != null ? Paths.get(e.getFilePath(), new String[0]).getFileName().toString() : "misc";
                    Map entries = resources.computeIfAbsent(fileName, k -> new LinkedHashMap());
                    entries.computeIfAbsent(e.getMessage(), f -> new ArrayList()).add(e);
                }
            });
            return resources;
        }
    }
}

