/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.project.model;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ApplicationModelUtils {
    public static Function<Element, Element> changeNodeName(String nameSpace, String name) {
        return e -> {
            if (e != null) {
                e.setNamespace(e.getDocument().getRootElement().getNamespace(nameSpace));
                e.setName(name);
            }
            return e;
        };
    }

    public static Function<Element, Element> addAttribute(String name, String value) {
        return e -> {
            if (e != null) {
                Attribute att = new Attribute(name, value);
                e.setAttribute(att);
            }
            return e;
        };
    }

    public static Function<Element, Element> changeAttribute(String name, Optional<String> newName, Optional<String> value) {
        return e -> {
            Attribute attribute;
            if (e != null && (attribute = e.getAttribute(name)) != null) {
                newName.ifPresent(nn -> attribute.setName(nn));
                value.ifPresent(v -> attribute.setValue(v));
            }
            return e;
        };
    }

    public static Function<Element, Element> removeAttribute(String name) {
        return e -> {
            Attribute attribute;
            if (e != null && (attribute = e.getAttribute(name)) != null) {
                e.removeAttribute(name);
            }
            return e;
        };
    }

    public static Function<Element, Element> moveContentToChild(String childNodeName) {
        return e -> {
            if (e != null) {
                List<Element> childElements = e.getChildren().stream().filter(s -> !s.getName().equals(childNodeName)).collect(Collectors.toList());
                childElements.forEach(Element::detach);
                e.getChild(childNodeName, e.getNamespace()).addContent(childElements);
            }
            return e;
        };
    }

    public static Function<Element, Element> moveAttributeToChildNode(String name, String childNodeName) {
        return e -> {
            if (e != null) {
                Attribute attribute = e.getAttribute(name);
                Element child = e.getChild(childNodeName, e.getNamespace());
                if (attribute != null && child != null) {
                    e.removeAttribute(attribute);
                    child.setAttribute(attribute);
                }
            }
            return e;
        };
    }

    public static Function<Element, Element> attributeToChildNode(String name) {
        return e -> {
            Attribute attribute;
            if (e != null && (attribute = e.getAttribute(name)) != null) {
                e.removeAttribute(attribute);
                Element child = new Element(name, e.getNamespace());
                child.setAttribute(new Attribute("value", attribute.getValue()));
                e.addContent(0, (Content)child);
            }
            return e;
        };
    }

    public static Function<Element, Element> addChildNode(String namespace, String name) {
        return e -> {
            Namespace ns = e.getDocument().getRootElement().getNamespace(namespace);
            if (e.getChild(name, ns) == null) {
                e.addContent((Content)new Element(name, ns));
            }
            return e;
        };
    }
}

