/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.project.model.artifact;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mulesoft.tools.migration.project.model.artifact.MuleArtifactJsonModelUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;

public class MuleArtifactJsonModel {
    public static final String BUNDLE_DESCRIPTOR_LOADER = "bundleDescriptorLoader";
    public static final String ID = "id";
    public static final String ATTRIBUTES = "attributes";
    public static final String CLASS_LOADER_MODEL_LOADER_DESCRIPTOR = "classLoaderModelLoaderDescriptor";
    private Gson gson = new GsonBuilder().setPrettyPrinting().enableComplexMapKeySerialization().create();
    private final JsonObject model;
    public static final String NAME = "name";
    public static final String CONFIGS = "configs";
    public static final String MIN_MULE_VERSION_FIELD = "minMuleVersion";
    public static final String REDEPLOYMENT_ENABLED = "redeploymentEnabled";
    public static final String SECURE_PROPERTIES = "secureProperties";
    public static final String REQUIRED_PRODUCT = "requiredProduct";

    public MuleArtifactJsonModel(String muleArtifactJsonContent) {
        JsonParser parser = new JsonParser();
        this.model = (JsonObject)parser.parse(muleArtifactJsonContent);
    }

    public MuleArtifactJsonModel(MuleApplicationModel model) {
        this(new MuleApplicationModelJsonSerializer().serialize((AbstractMuleArtifactModel)model));
    }

    public void addProperty(String key, String value) throws IllegalArgumentException {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key should not be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Value should not be null");
        this.model.addProperty(key, value);
    }

    public Optional<Object> getProperty(String key) {
        if (this.has(key)) {
            return Optional.ofNullable(this.model.get(key).getAsString());
        }
        return Optional.empty();
    }

    public boolean has(String member) {
        Preconditions.checkArgument((member != null ? 1 : 0) != 0, (Object)"Member should not be null");
        return this.model.has(member);
    }

    public boolean remove(String member) {
        Preconditions.checkArgument((member != null ? 1 : 0) != 0, (Object)"Member should not be null");
        return this.model.remove(member) != null;
    }

    public String getMinMuleVersion() {
        if (this.model.has(MIN_MULE_VERSION_FIELD)) {
            return this.model.get(MIN_MULE_VERSION_FIELD).getAsString();
        }
        this.model.addProperty(MIN_MULE_VERSION_FIELD, "4.1.1");
        return "4.1.1";
    }

    public void setMinMuleVersion(String minMuleVersion) {
        Preconditions.checkArgument((minMuleVersion != null ? 1 : 0) != 0, (Object)"minMuleVersion should not be null");
        this.model.addProperty(MIN_MULE_VERSION_FIELD, minMuleVersion);
    }

    public Optional<List<String>> getSecureProperties() {
        if (this.model.has(SECURE_PROPERTIES)) {
            return Optional.ofNullable(this.gson.fromJson((JsonElement)this.model.getAsJsonArray(SECURE_PROPERTIES), new TypeToken<List<String>>(){}.getType()));
        }
        return Optional.empty();
    }

    public void setSecureProperties(List<String> secureProperties) {
        Preconditions.checkArgument((secureProperties != null ? 1 : 0) != 0, (Object)"secureProperties should not be null");
        JsonElement secureProps = this.gson.toJsonTree(secureProperties, new TypeToken<List<String>>(){}.getType());
        this.model.add(SECURE_PROPERTIES, secureProps);
    }

    public Optional<Set<String>> getConfigs() {
        if (this.model.has(CONFIGS)) {
            return Optional.ofNullable(this.gson.fromJson((JsonElement)this.model.getAsJsonArray(CONFIGS), new TypeToken<Set<String>>(){}.getType()));
        }
        return Optional.empty();
    }

    public void setConfigs(Set<String> configs) {
        Preconditions.checkArgument((configs != null ? 1 : 0) != 0, (Object)"configs should not be null");
        JsonElement configsList = this.gson.toJsonTree(configs, new TypeToken<Set<String>>(){}.getType());
        this.model.add(CONFIGS, configsList);
    }

    public Optional<MuleArtifactLoaderDescriptor> getBundleDescriptorLoader() {
        MuleArtifactLoaderDescriptor descriptor = null;
        String id = null;
        Map attributes = null;
        if (this.model.has(BUNDLE_DESCRIPTOR_LOADER)) {
            JsonObject bundleDescriptorLoader = (JsonObject)this.model.get(BUNDLE_DESCRIPTOR_LOADER);
            if (bundleDescriptorLoader.has(ID)) {
                id = bundleDescriptorLoader.get(ID).getAsString();
            }
            if (bundleDescriptorLoader.has(ATTRIBUTES)) {
                attributes = (Map)this.gson.fromJson(bundleDescriptorLoader.get(ATTRIBUTES), new TypeToken<Map<String, Object>>(){}.getType());
            }
            descriptor = new MuleArtifactLoaderDescriptor(id, attributes);
        }
        return Optional.ofNullable(descriptor);
    }

    public void setBundleDescriptorLoader(String id, Map<String, Object> attributes) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"id should not be null");
        Preconditions.checkArgument((attributes != null ? 1 : 0) != 0, (Object)"attributes should not be null");
        JsonElement descriptor = this.gson.toJsonTree((Object)new MuleArtifactLoaderDescriptor(id, attributes), new TypeToken<MuleArtifactLoaderDescriptor>(){}.getType());
        this.model.add(BUNDLE_DESCRIPTOR_LOADER, descriptor);
    }

    public Optional<MuleArtifactLoaderDescriptor> getClassLoaderModelLoaderDescriptor() {
        MuleArtifactLoaderDescriptor descriptor = null;
        String id = null;
        Map attributes = null;
        if (this.model.has(CLASS_LOADER_MODEL_LOADER_DESCRIPTOR)) {
            JsonObject bundleDescriptorLoader = (JsonObject)this.model.get(CLASS_LOADER_MODEL_LOADER_DESCRIPTOR);
            if (bundleDescriptorLoader.has(ID)) {
                id = bundleDescriptorLoader.get(ID).getAsString();
            }
            if (bundleDescriptorLoader.has(ATTRIBUTES)) {
                attributes = (Map)this.gson.fromJson(bundleDescriptorLoader.get(ATTRIBUTES), new TypeToken<Map<String, Object>>(){}.getType());
            }
            descriptor = new MuleArtifactLoaderDescriptor(id, attributes);
        }
        return Optional.ofNullable(descriptor);
    }

    public void setClassLoaderModelLoaderDescriptor(String id, Map<String, Object> attributes) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"id should not be null");
        Preconditions.checkArgument((attributes != null ? 1 : 0) != 0, (Object)"attributes should not be null");
        JsonElement descriptor = this.gson.toJsonTree((Object)new MuleArtifactLoaderDescriptor(id, attributes), new TypeToken<MuleArtifactLoaderDescriptor>(){}.getType());
        this.model.add(CLASS_LOADER_MODEL_LOADER_DESCRIPTOR, descriptor);
    }

    public Optional<String> getName() {
        if (this.model.has(NAME)) {
            return Optional.ofNullable(this.model.get(NAME).getAsString());
        }
        return Optional.empty();
    }

    public void setName(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name should not be null");
        this.model.addProperty(NAME, name);
    }

    public Optional<Product> getRequiredProduct() {
        if (this.model.has(REQUIRED_PRODUCT)) {
            return Optional.of(Product.valueOf((String)this.model.get(REQUIRED_PRODUCT).getAsString()));
        }
        return Optional.empty();
    }

    public void setRequiredProduct(Product requiredProduct) {
        Preconditions.checkArgument((requiredProduct != null ? 1 : 0) != 0, (Object)"requiredProduct should not be null");
        this.model.addProperty(REQUIRED_PRODUCT, requiredProduct.toString());
    }

    public Optional<Boolean> getIsRedeploymentEnabled() {
        if (this.model.has(REDEPLOYMENT_ENABLED)) {
            return Optional.of(this.model.get(REDEPLOYMENT_ENABLED).getAsBoolean());
        }
        return Optional.empty();
    }

    public void setIsRedeploymentEnabled(boolean redeploymentEnabled) {
        this.model.addProperty(REDEPLOYMENT_ENABLED, Boolean.valueOf(redeploymentEnabled));
    }

    public String toString() {
        return this.gson.toJson((JsonElement)this.model);
    }

    public static class MuleApplicationJsonModelBuilder {
        private Path muleArtifactJsonPath;
        private String muleVersion;

        public MuleApplicationJsonModelBuilder withMuleArtifactJson(Path muleArtifactJsonPath) {
            this.muleArtifactJsonPath = muleArtifactJsonPath;
            return this;
        }

        public MuleApplicationJsonModelBuilder withMuleVersion(String muleVersion) {
            this.muleVersion = muleVersion;
            return this;
        }

        public MuleArtifactJsonModel build() throws IOException {
            Preconditions.checkArgument((this.muleArtifactJsonPath != null ? 1 : 0) != 0, (Object)"mule-artifact.json path should not be null");
            if (!this.muleArtifactJsonPath.toAbsolutePath().toFile().exists() && this.muleArtifactJsonPath.toAbsolutePath().getParent().toFile().exists()) {
                return MuleArtifactJsonModelUtils.buildMinimalMuleArtifactJson(this.muleVersion);
            }
            String muleArtifactJsonContent = FileUtils.readFileToString((File)this.muleArtifactJsonPath.toFile(), (String)null);
            return new MuleArtifactJsonModel(muleArtifactJsonContent);
        }
    }
}

