/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.project.model.pom;

import com.mulesoft.tools.migration.project.model.pom.Dependency;
import com.mulesoft.tools.migration.project.model.pom.Plugin;
import com.mulesoft.tools.migration.project.model.pom.PomModel;
import com.mulesoft.tools.migration.project.model.pom.Repository;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class PomModelUtils {
    public static final String MULE_APPLICATION_4_PACKAGING_TYPE = "mule-application";
    public static final String MULE_APPLICATION_3_PACKAGING_TYPE = "mule";
    public static final String DEFAULT_MODEL_VERSION = "4.0.0";
    public static final String MULE_MAVEN_PLUGIN_ARTIFACT_ID = "mule-maven-plugin";
    public static final String MULE_MAVEN_PLUGIN_GROUP_ID = "org.mule.tools.maven";
    public static final String MULE_MAVEN_PLUGIN_VERSION = "3.2.1";
    private static final String MULESOFT_RELEASES = "mulesoft-releases";
    private static final String MULESOFT_RELEASES_REPOSITORY_NAME = "MuleSoft Releases Repository";
    private static final String MULESOFT_RELEASES_REPOSITORY_URL = "https://repository.mulesoft.org/releases/";
    private static final String DEFAULT_LAYOUT = "default";

    public static PomModel buildMinimalMule4ApplicationPom(String groupId, String artifactId, String version, String packaging) {
        PomModel model = new PomModel();
        model.setGroupId(groupId);
        model.setArtifactId(artifactId);
        model.setVersion(version);
        model.setPackaging(packaging);
        model.setModelVersion(DEFAULT_MODEL_VERSION);
        Plugin muleMavenPlugin = PomModelUtils.buildMule4MuleMavenPluginConfiguration();
        model.addPlugin(muleMavenPlugin);
        model.addRepository(PomModelUtils.getMuleReleasesRepository());
        Repository pluginsRepository = PomModelUtils.getMuleReleasesRepository();
        pluginsRepository.setSnapshotsEnabled(true);
        model.addPluginRepository(pluginsRepository);
        return model;
    }

    public static Plugin buildMule4MuleMavenPluginConfiguration() {
        return new Plugin.PluginBuilder().withArtifactId(MULE_MAVEN_PLUGIN_ARTIFACT_ID).withGroupId(MULE_MAVEN_PLUGIN_GROUP_ID).withVersion(MULE_MAVEN_PLUGIN_VERSION).build();
    }

    public static Repository getMuleReleasesRepository() {
        Repository repository = new Repository.RepositoryBuilder().withId(MULESOFT_RELEASES).build();
        repository.setName(MULESOFT_RELEASES_REPOSITORY_NAME);
        repository.setUrl(MULESOFT_RELEASES_REPOSITORY_URL);
        repository.setLayout(DEFAULT_LAYOUT);
        return repository;
    }

    public static void addSharedLibs(PomModel model, Dependency ... dependencies) {
        model.getPlugins().stream().filter(plugin -> MULE_MAVEN_PLUGIN_GROUP_ID.equals(plugin.getGroupId()) && MULE_MAVEN_PLUGIN_ARTIFACT_ID.equals(plugin.getArtifactId())).findFirst().map(p -> {
            Xpp3Dom configuration = p.getConfiguration();
            Xpp3Dom sharedLibraries = configuration.getChild("sharedLibraries");
            if (sharedLibraries == null) {
                sharedLibraries = new Xpp3Dom("sharedLibraries");
                p.getConfiguration().addChild(sharedLibraries);
            }
            return sharedLibraries;
        }).ifPresent(sharedLibraries -> {
            for (Dependency dependency : dependencies) {
                Xpp3Dom sharedLib = new Xpp3Dom("sharedLibrary");
                Xpp3Dom groupIdNode = new Xpp3Dom("groupId");
                groupIdNode.setValue(dependency.getGroupId());
                sharedLib.addChild(groupIdNode);
                Xpp3Dom artifactIdNode = new Xpp3Dom("artifactId");
                sharedLib.addChild(artifactIdNode);
                artifactIdNode.setValue(dependency.getArtifactId());
                sharedLibraries.addChild(sharedLib);
            }
        });
    }
}

