/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.amqp;

import com.mulesoft.tools.migration.library.mule.steps.amqp.values.AckModeAttributeMapper;
import com.mulesoft.tools.migration.library.mule.steps.amqp.values.DeliveryModeAttributeMapper;
import com.mulesoft.tools.migration.library.mule.steps.amqp.values.SimpleAttributeMapper;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.AttributeValueMapper;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class AbstractAmqpEndpoint
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    protected static final String AMQP_NAMESPACE_PREFIX = "amqp";
    protected static final String AMQPS_NAMESPACE_PREFIX = "amqps";
    public static final String AMQP_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/amqp";
    public static final String AMQPS_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/amqps";
    public static final Namespace AMQP_NAMESPACE = Namespace.getNamespace((String)"amqp", (String)"http://www.mulesoft.org/schema/mule/amqp");
    public static final Namespace AMQPS_NAMESPACE = Namespace.getNamespace((String)"amqps", (String)"http://www.mulesoft.org/schema/mule/amqps");
    public static final Namespace TLS_NAMESPACE = Namespace.getNamespace((String)"tls", (String)"http://www.mulesoft.org/schema/mule/tls");
    private static final Map<String, SimpleAttributeMapper> CONNECTION_ATTRIBUTES = new HashMap<String, SimpleAttributeMapper>();
    private static final Map<String, SimpleAttributeMapper> CONSUMER_CONFIG_ATTRIBUTES;
    private static final Map<String, SimpleAttributeMapper> PUBLISHER_CONFIG_ATTRIBUTES;
    private static final Map<String, SimpleAttributeMapper> QOS_CONFIG_ATTRIBUTES;
    private ExpressionMigrator expressionMigrator;

    protected static Optional<Element> resolveAmqpConnector(Element object, ApplicationModel appModel) {
        Optional<Element> connector;
        if (object.getAttribute("connector-ref") != null) {
            connector = Optional.of(AbstractAmqpEndpoint.getConnector(object.getAttributeValue("connector-ref"), appModel));
            object.removeAttribute("connector-ref");
        } else {
            connector = AbstractAmqpEndpoint.getDefaultConnector(appModel);
        }
        return connector;
    }

    protected static Element getConnector(String connectorName, ApplicationModel appModel) {
        return appModel.getNode(StringUtils.substring((String)"/*/*[(namespace-uri()='http://www.mulesoft.org/schema/mule/amqp' or namespace-uri()='http://www.mulesoft.org/schema/mule/amqps') and ((local-name()='connector'))]", (int)0, (int)-1) + " and @name = '" + connectorName + "']");
    }

    protected static Optional<Element> getDefaultConnector(ApplicationModel appModel) {
        return appModel.getNodeOptional("/*/*[(namespace-uri()='http://www.mulesoft.org/schema/mule/amqp' or namespace-uri()='http://www.mulesoft.org/schema/mule/amqps') and ((local-name()='connector'))]");
    }

    public static String migrateAmqpConfig(Element object, MigrationReport report, Optional<Element> connector, ApplicationModel appModel) {
        String configName = connector.map(conn -> conn.getAttributeValue("name")).orElse((object.getAttribute("name") != null ? object.getAttributeValue("name") : (object.getAttribute("ref") != null ? object.getAttributeValue("ref") : "")).replaceAll("\\\\", "_") + "AmqpConfig");
        Optional config = appModel.getNodeOptional("*/*[(namespace-uri()='http://www.mulesoft.org/schema/mule/amqp' or namespace-uri()='http://www.mulesoft.org/schema/mule/amqps') and local-name()='config' and @name='" + configName + "']");
        config.orElseGet(() -> {
            Element amqpConfig = new Element("config", AMQP_NAMESPACE);
            amqpConfig.setAttribute("name", configName);
            connector.ifPresent(conn -> {
                AbstractAmqpEndpoint.addConnectionToConfig(amqpConfig, conn, appModel, report);
                if (XmlDslUtils.hasAttribute((Element)conn, (String)"fallbackAddresses")) {
                    report.report("amqp.fallbackAddresses", conn, amqpConfig, new String[0]);
                }
                if (XmlDslUtils.hasAttribute((Element)conn, (String)"default-return-endpoint-ref")) {
                    report.report("amqp.returnListener", conn, amqpConfig, new String[0]);
                }
                if (AbstractAmqpEndpoint.mustAddConsumerConfig(conn)) {
                    AbstractAmqpEndpoint.addConsumerConfigToConfig(amqpConfig, conn, appModel, report);
                }
                if (AbstractAmqpEndpoint.mustAddPublisherConfig(conn)) {
                    AbstractAmqpEndpoint.addPublisherConfigToConfig(amqpConfig, conn, appModel, report);
                }
                if (AbstractAmqpEndpoint.mustAddQoSConfig(conn)) {
                    AbstractAmqpEndpoint.addQoSConfigToConfig(amqpConfig, conn, appModel, report);
                }
                if (XmlDslUtils.hasAttribute((Element)conn, (String)"activeDeclarationsOnly")) {
                    String fallbackQueueActionValue = Boolean.toString(!Boolean.parseBoolean(conn.getAttribute("activeDeclarationsOnly").getValue()));
                    amqpConfig.setAttribute("createFallbackQueue", fallbackQueueActionValue);
                    amqpConfig.setAttribute("createFallbackExchange", fallbackQueueActionValue);
                    report.report("activeDeclarationsOnly", conn, amqpConfig, new String[0]);
                }
            });
            XmlDslUtils.addTopLevelElement((Element)amqpConfig, (Document)connector.map(c -> c.getDocument()).orElse(object.getDocument()));
            return amqpConfig;
        });
        return configName;
    }

    private static void addQoSConfigToConfig(Element amqpConfig, Element m3Connector, ApplicationModel appModel, MigrationReport report) {
        AbstractAmqpEndpoint.addAdditionalConfig(amqpConfig, m3Connector, appModel, report, "quality-of-service-config", QOS_CONFIG_ATTRIBUTES);
    }

    private static void addPublisherConfigToConfig(Element amqpConfig, Element m3Connector, ApplicationModel appModel, MigrationReport report) {
        AbstractAmqpEndpoint.addAdditionalConfig(amqpConfig, m3Connector, appModel, report, "publisher-config", PUBLISHER_CONFIG_ATTRIBUTES);
    }

    private static boolean mustAddQoSConfig(Element connector) {
        return AbstractAmqpEndpoint.mustAddAdditionalConfig(connector, QOS_CONFIG_ATTRIBUTES.keySet());
    }

    private static boolean mustAddPublisherConfig(Element connector) {
        return AbstractAmqpEndpoint.mustAddAdditionalConfig(connector, PUBLISHER_CONFIG_ATTRIBUTES.keySet());
    }

    private static boolean mustAddConsumerConfig(Element connector) {
        return AbstractAmqpEndpoint.mustAddAdditionalConfig(connector, CONSUMER_CONFIG_ATTRIBUTES.keySet());
    }

    private static boolean mustAddAdditionalConfig(Element connector, Set<String> attributes) {
        for (String attribute : attributes) {
            if (!XmlDslUtils.hasAttribute((Element)connector, (String)attribute)) continue;
            return true;
        }
        return false;
    }

    private static void addConsumerConfigToConfig(Element amqpConfig, Element m3Connector, ApplicationModel appModel, MigrationReport report) {
        AbstractAmqpEndpoint.addAdditionalConfig(amqpConfig, m3Connector, appModel, report, "consumer-config", CONSUMER_CONFIG_ATTRIBUTES);
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }

    public static Element addAdditionalConfig(Element m4AmqpConfig, Element m3Connector, ApplicationModel appModel, MigrationReport report, String additionalConfigName, Map<String, SimpleAttributeMapper> attributesMap) {
        Element connection = new Element(additionalConfigName, AMQP_NAMESPACE);
        m4AmqpConfig.addContent((Content)connection);
        attributesMap.keySet().forEach(attr -> XmlDslUtils.copyAttributeIfPresent((Element)m3Connector, (Element)connection, (String)attr, (String)((SimpleAttributeMapper)attributesMap.get(attr)).getAttributeName(), (AttributeValueMapper)((AttributeValueMapper)attributesMap.get(attr))));
        return connection;
    }

    public static void addConnectionToConfig(Element m4AmqpConfig, Element m3Connector, ApplicationModel appModel, MigrationReport report) {
        Element conn = AbstractAmqpEndpoint.addAdditionalConfig(m4AmqpConfig, m3Connector, appModel, report, "connection", CONNECTION_ATTRIBUTES);
        if (!XmlDslUtils.hasAttribute((Element)conn, (String)"host")) {
            conn.setAttribute("host", "localhost");
        }
        if (!XmlDslUtils.hasAttribute((Element)conn, (String)"username")) {
            conn.setAttribute("username", "guest");
        }
        if (!XmlDslUtils.hasAttribute((Element)conn, (String)"password")) {
            conn.setAttribute("password", "guest");
        }
        if (m3Connector.getNamespace().equals((Object)AMQPS_NAMESPACE)) {
            AbstractAmqpEndpoint.setTlsContext(m3Connector, conn);
        }
    }

    private static void setTlsContext(Element amqp3Connector, Element conn) {
        conn.setAttribute("useTls", "true");
        ArrayList inputChildren = new ArrayList(amqp3Connector.getChildren());
        Element tlsContext = new Element("context", TLS_NAMESPACE);
        XmlDslUtils.copyAttributeIfPresent((Element)amqp3Connector, (Element)tlsContext, (String)"sslProtocol", (String)"enabledProtocols");
        inputChildren.forEach(child -> {
            if (child.getNamespace().equals((Object)AMQPS_NAMESPACE) && child.getName().equals("ssl-key-store")) {
                Element keyStore = new Element("key-store", TLS_NAMESPACE);
                XmlDslUtils.copyAttributeIfPresent((Element)child, (Element)keyStore, (String)"path");
                XmlDslUtils.copyAttributeIfPresent((Element)child, (Element)keyStore, (String)"storePassword", (String)"password");
                XmlDslUtils.copyAttributeIfPresent((Element)child, (Element)keyStore, (String)"keyPassword");
                XmlDslUtils.copyAttributeIfPresent((Element)child, (Element)keyStore, (String)"type");
                XmlDslUtils.copyAttributeIfPresent((Element)child, (Element)keyStore, (String)"alias");
                XmlDslUtils.copyAttributeIfPresent((Element)child, (Element)keyStore, (String)"algorithm");
                tlsContext.addContent((Content)keyStore);
            }
            if (child.getNamespace().equals((Object)AMQPS_NAMESPACE) && child.getName().equals("ssl-trust-store")) {
                Element trustStore = new Element("trust-store", TLS_NAMESPACE);
                XmlDslUtils.copyAttributeIfPresent((Element)child, (Element)trustStore, (String)"path");
                XmlDslUtils.copyAttributeIfPresent((Element)child, (Element)trustStore, (String)"storePassword", (String)"password");
                XmlDslUtils.copyAttributeIfPresent((Element)child, (Element)trustStore, (String)"type", (String)"type");
                tlsContext.addContent((Content)trustStore);
            }
        });
        if (tlsContext.hasAttributes() || !tlsContext.getChildren().isEmpty()) {
            conn.addContent((Content)tlsContext);
        }
    }

    protected String resolveRemovalStrategy(Boolean autoDelete, Boolean durable) {
        if (!durable.booleanValue() && !autoDelete.booleanValue()) {
            return "SHUTDOWN";
        }
        if (durable.booleanValue() && !autoDelete.booleanValue()) {
            return "EXPLICIT";
        }
        if (!durable.booleanValue() && autoDelete.booleanValue()) {
            return "UNUSED";
        }
        return null;
    }

    static {
        CONNECTION_ATTRIBUTES.put("username", new SimpleAttributeMapper("username"));
        CONNECTION_ATTRIBUTES.put("password", new SimpleAttributeMapper("password"));
        CONNECTION_ATTRIBUTES.put("host", new SimpleAttributeMapper("host"));
        CONNECTION_ATTRIBUTES.put("port", new SimpleAttributeMapper("port"));
        CONNECTION_ATTRIBUTES.put("virtualHost", new SimpleAttributeMapper("virtualHost"));
        CONNECTION_ATTRIBUTES.put("requestedHeartbeat", new SimpleAttributeMapper("heartbeatTimeout"));
        CONSUMER_CONFIG_ATTRIBUTES = new HashMap<String, SimpleAttributeMapper>();
        CONSUMER_CONFIG_ATTRIBUTES.put("ackMode", new AckModeAttributeMapper());
        CONSUMER_CONFIG_ATTRIBUTES.put("numberOfChannels", new SimpleAttributeMapper("numberOfConsumers"));
        CONSUMER_CONFIG_ATTRIBUTES.put("noLocal", new SimpleAttributeMapper("noLocal"));
        CONSUMER_CONFIG_ATTRIBUTES.put("exclusiveConsumers", new SimpleAttributeMapper("exclusiveConsumers"));
        PUBLISHER_CONFIG_ATTRIBUTES = new HashMap<String, SimpleAttributeMapper>();
        PUBLISHER_CONFIG_ATTRIBUTES.put("deliveryMode", new DeliveryModeAttributeMapper());
        PUBLISHER_CONFIG_ATTRIBUTES.put("priority", new SimpleAttributeMapper("priority"));
        PUBLISHER_CONFIG_ATTRIBUTES.put("mandatory", new SimpleAttributeMapper("mandatory"));
        PUBLISHER_CONFIG_ATTRIBUTES.put("immediate", new SimpleAttributeMapper("immediate"));
        PUBLISHER_CONFIG_ATTRIBUTES.put("requestBrokerConfirms", new SimpleAttributeMapper("requestBrokerConfirms"));
        QOS_CONFIG_ATTRIBUTES = new HashMap<String, SimpleAttributeMapper>();
        QOS_CONFIG_ATTRIBUTES.put("prefetchSize", new SimpleAttributeMapper("prefetchSize"));
        QOS_CONFIG_ATTRIBUTES.put("prefetchCount", new SimpleAttributeMapper("prefetchCount"));
    }
}

