/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core;

import com.mulesoft.tools.migration.library.mule.steps.validation.ValidationMigration;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.ArrayList;
import org.jdom2.Content;
import org.jdom2.Element;

public class FirstSuccessful
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    public static final String XPATH_SELECTOR = XmlDslUtils.getCoreXPathSelector((String)"first-successful");
    private ExpressionMigrator expressionMigrator;

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }

    public String getDescription() {
        return "Migrate First Successful.";
    }

    public FirstSuccessful() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        ArrayList childs = new ArrayList(element.getChildren());
        childs.forEach(c -> {
            if (c.getName().equals("processor-chain")) {
                c.setName("route");
            } else if (!c.getName().equals("route")) {
                Element route = new Element("route", element.getNamespace());
                Integer index = element.indexOf((Content)c);
                c.detach();
                route.addContent((Content)c);
                element.addContent(index.intValue(), (Content)route);
            }
        });
        if (element.getAttribute("failureExpression") != null) {
            ValidationMigration.addValidationNamespace(element.getDocument());
            Element validation = new Element("is-false", ValidationMigration.VALIDATION_NAMESPACE);
            String expression = element.getAttributeValue("failureExpression");
            validation.setAttribute("expression", this.getExpressionMigrator().migrateExpression(expression, true, element));
            element.getChildren().forEach(c -> c.addContent(c.getContent().size(), (Content)validation.clone()));
            element.removeAttribute("failureExpression");
        }
    }
}

