/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core;

import com.mulesoft.tools.migration.exception.MigrationStepException;
import com.mulesoft.tools.migration.project.model.ApplicationModelUtils;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.Optional;
import org.jdom2.Element;

public class TransactionalScope
extends AbstractApplicationModelMigrationStep {
    public static final String XPATH_SELECTOR = "//*[(namespace-uri()='" + XmlDslUtils.CORE_NAMESPACE.getURI() + "' and local-name()='transactional') or (namespace-uri()='" + XmlDslUtils.CORE_EE_NAMESPACE.getURI() + "' and (local-name()='xa-transactional' or local-name()='multi-transactional'))]";

    public String getDescription() {
        return "Update Transactional Scope to Try component.";
    }

    public TransactionalScope() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        try {
            boolean xa = element != null && element.getName().equals("xa-transactional");
            Element transformed = (Element)ApplicationModelUtils.changeNodeName((String)"", (String)"try").andThen(ApplicationModelUtils.changeAttribute((String)"action", Optional.of("transactionalAction"), Optional.empty())).apply(element);
            if (xa) {
                transformed.setAttribute("transactionType", "XA");
            }
        }
        catch (Exception ex) {
            throw new MigrationStepException("Failed to migrate transactional scope.");
        }
    }
}

