/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.core.dw;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import org.mule.weave.v2.V2LangMigrant;

public class DataWeaveHelper {
    public static File getMigrationScriptFolder(Path basePath) {
        File migrationScripts = new File(basePath.toFile(), "src/main/resources/migration");
        migrationScripts.mkdirs();
        return migrationScripts;
    }

    public static void scriptWithHeader(File migrationScriptFolder, String scriptName, String outputType, String body) throws IOException {
        try (FileWriter writer = new FileWriter(new File(migrationScriptFolder, scriptName));){
            writer.write("%dw 2.0" + System.lineSeparator());
            writer.write("output " + outputType + System.lineSeparator());
            writer.write(" ---" + System.lineSeparator());
            writer.write(body);
        }
    }

    public static void library(File migrationScriptFolder, String libName, String body) throws IOException {
        try (FileWriter writer = new FileWriter(new File(migrationScriptFolder, libName));){
            writer.write("%dw 2.0" + System.lineSeparator() + System.lineSeparator());
            writer.write(body);
        }
    }

    public static String migrateDWToV2(String dwScript) {
        return V2LangMigrant.migrateToV2((String)dwScript);
    }
}

