/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.domain;

import com.mulesoft.tools.migration.exception.MigrationAbortException;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.project.model.pom.Dependency;
import com.mulesoft.tools.migration.project.model.pom.PomModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.category.PomContribution;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class DomainReferencePomContribution
implements PomContribution {
    private ApplicationModel applicationModel;

    public String getDescription() {
        return "Add Domain dependency.";
    }

    public void execute(PomModel object, MigrationReport report) throws RuntimeException {
        Properties properties = new Properties();
        File file = this.getApplicationModel().getSourceProjectBasePath().resolve("src" + File.separator + "main" + File.separator + "app" + File.separator + "mule-deploy.properties").toFile();
        if (!file.exists()) {
            return;
        }
        try (FileInputStream inStream = new FileInputStream(file);){
            properties.load(inStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!properties.containsKey("domain")) {
            return;
        }
        String domain = properties.getProperty("domain");
        if ("default".equals(domain)) {
            return;
        }
        if (this.getApplicationModel().getDomainDocuments() == null || this.getApplicationModel().getDomainDocuments().isEmpty()) {
            throw new MigrationAbortException(String.format("The application to migrate references a domain '%s'. Call the migrator with the 'parentDomainBasePath' parameter indicating the Mule 3 source for that domain.", domain));
        }
        object.addDependency(new Dependency.DependencyBuilder().withGroupId("org.mule.migrated").withArtifactId(domain).withVersion("1.0.0-M4-SNAPSHOT").withClassifier("mule-domain").withScope("provided").build());
    }

    public ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    public void setApplicationModel(ApplicationModel appModel) {
        this.applicationModel = appModel;
    }
}

