/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.email;

import com.mulesoft.tools.migration.library.mule.steps.email.SmtpOutboundEndpoint;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.Optional;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SmtpsOutboundEndpoint
extends SmtpOutboundEndpoint {
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/smtps' and local-name()='outbound-endpoint']";
    private ExpressionMigrator expressionMigrator;

    @Override
    public String getDescription() {
        return "Update SMTPs transport outbound endpoint.";
    }

    public SmtpsOutboundEndpoint() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    @Override
    public void execute(Element object, MigrationReport report) throws RuntimeException {
        Optional<Element> smtpsConnector = object.getAttribute("connector-ref") != null ? Optional.of(this.getConnector(object.getAttributeValue("connector-ref"))) : this.getDefaultConnector();
        super.execute(object, report);
        Element smtpsConnection = this.getApplicationModel().getNode("/*/*[namespace-uri() = '" + EMAIL_NAMESPACE.getURI() + "' and local-name() = 'smtp-config' and @name = '" + object.getAttributeValue("config-ref") + "']/*[namespace-uri() = '" + EMAIL_NAMESPACE.getURI() + "' and local-name() = 'smtps-connection']");
        if (smtpsConnector.isPresent() && smtpsConnection.getChild("context", TLS_NAMESPACE) == null) {
            Element tlsClient;
            Element tlsContext = new Element("context", TLS_NAMESPACE);
            boolean tlsConfigured = false;
            Namespace smtpsNamespace = Namespace.getNamespace((String)"smtps", (String)"http://www.mulesoft.org/schema/mule/smtps");
            Element tlsKeyStore = smtpsConnector.get().getChild("tls-client", smtpsNamespace);
            if (tlsKeyStore != null) {
                Element keyStore = new Element("key-store", TLS_NAMESPACE);
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"path");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"storePassword", (String)"password");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"keyPassword");
                if (tlsKeyStore.getAttribute("class") != null) {
                    report.report("email.smtpKeyStoreClass", tlsKeyStore, tlsKeyStore, new String[0]);
                }
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"type", (String)"type");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"keyAlias", (String)"alias");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsKeyStore, (Element)keyStore, (String)"algorithm");
                tlsContext.addContent((Content)keyStore);
                tlsConfigured = true;
            }
            if ((tlsClient = smtpsConnector.get().getChild("tls-trust-store", smtpsNamespace)) != null) {
                Element keyStore = new Element("trust-store", TLS_NAMESPACE);
                XmlDslUtils.copyAttributeIfPresent((Element)tlsClient, (Element)keyStore, (String)"path");
                XmlDslUtils.copyAttributeIfPresent((Element)tlsClient, (Element)keyStore, (String)"storePassword", (String)"password");
                if (tlsClient.getAttribute("class") != null) {
                    report.report("email.smtpTlsClientClass", tlsClient, tlsClient, new String[0]);
                }
                XmlDslUtils.copyAttributeIfPresent((Element)tlsClient, (Element)keyStore, (String)"type", (String)"type");
                tlsContext.addContent((Content)keyStore);
                tlsConfigured = true;
            }
            if (tlsConfigured) {
                this.getApplicationModel().addNameSpace(TLS_NAMESPACE.getPrefix(), TLS_NAMESPACE.getURI(), "http://www.mulesoft.org/schema/mule/tls/current/mule-tls.xsd");
                smtpsConnection.addContent((Content)tlsContext);
            }
        }
    }

    @Override
    protected Element createConnection() {
        return new Element("smtps-connection", EMAIL_NAMESPACE);
    }

    @Override
    protected Element getConnection(Element m4Config) {
        return m4Config.getChild("smtps-connection", EMAIL_NAMESPACE);
    }

    @Override
    protected Element getConnector(String connectorName) {
        return this.getApplicationModel().getNode("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/smtps' and (local-name()='connector' or local-name()='gmail-connector') and @name = '" + connectorName + "']");
    }

    @Override
    protected Optional<Element> getDefaultConnector() {
        return this.getApplicationModel().getNodeOptional("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/smtps' and (local-name()='connector' or local-name()='gmail-connector')]");
    }
}

