/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.expression;

import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.Optional;
import java.util.StringJoiner;
import org.jdom2.Element;

public class SimpleExpressionTransformer
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    public static final String XPATH_SELECTOR = "//mule:expression-transformer[not(@evaluator) and not(@returnClass)]";
    private ExpressionMigrator expressionMigrator;

    public SimpleExpressionTransformer() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        String migratedExpression;
        object.setName("set-payload");
        if (object.getChildren().isEmpty()) {
            migratedExpression = this.getElementExpressionValue(object).orElse("#[]");
            object.removeAttribute("expression");
        } else if (object.getChildren().size() == 1 && ((Element)object.getChildren().get(0)).getName().equals("return-argument")) {
            Element returnArgument = (Element)object.getChildren().get(0);
            migratedExpression = this.getElementExpressionValue(returnArgument).orElse("#[]");
            returnArgument.detach();
        } else {
            report.report("expressionTransformer.multipleTransforms", object, object, new String[0]);
            return;
        }
        Optional<String> encoding = Optional.ofNullable(object.getAttributeValue("encoding"));
        object.removeAttribute("encoding");
        if (object.getAttribute("mimeType") != null) {
            StringJoiner outputHeader = new StringJoiner(" ").add("output");
            outputHeader.add(object.getAttributeValue("mimeType"));
            object.removeAttribute("mimeType");
            encoding.ifPresent(enc -> outputHeader.add(String.format("encoding='%s'", enc)));
            outputHeader.add("--- ");
            StringBuilder stringBuilder = new StringBuilder(migratedExpression);
            stringBuilder.insert(2, outputHeader.toString());
            migratedExpression = stringBuilder.toString();
        }
        object.setAttribute("value", migratedExpression);
    }

    private Optional<String> getElementExpressionValue(Element element) {
        if (element.getAttribute("expression") != null) {
            String currentExpression = this.getExpressionMigrator().wrap(element.getAttributeValue("expression"));
            String migratedExpression = this.getExpressionMigrator().migrateExpression(currentExpression, true, element);
            return Optional.of(migratedExpression);
        }
        return Optional.empty();
    }
}

