/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.http;

import com.mulesoft.tools.migration.library.mule.steps.http.AbstractHttpConnectorMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class HttpConnectorUriParams
extends AbstractHttpConnectorMigrationStep {
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and (local-name()='uri-param' or (local-name()='uri-params' and normalize-space(text())=''))]";

    public String getDescription() {
        return "Update HTTP uri params in request builders.";
    }

    public HttpConnectorUriParams() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        object.setNamespace(HTTP_NAMESPACE);
        int idx = object.getParent().indexOf((Content)object);
        if ("uri-params".equals(object.getName())) {
            String paramsExpr = object.getAttributeValue("expression");
            this.setMule4MapBuilderTagText(idx, "uri-params", object.getParentElement(), HTTP_NAMESPACE, report, () -> this.getExpressionMigrator().migrateExpression(this.getExpressionMigrator().wrap(paramsExpr), true, object), expr -> this.getExpressionMigrator().wrap(this.getExpressionMigrator().unwrap(expr) + " ++ " + this.getExpressionMigrator().unwrap(this.getExpressionMigrator().migrateExpression(this.getExpressionMigrator().wrap(paramsExpr), true, object))));
            object.getParent().removeContent((Content)object);
            XmlDslUtils.setText((Element)object, (String)this.getExpressionMigrator().migrateExpression(this.getExpressionMigrator().wrap(paramsExpr), true, object));
        }
        if ("uri-param".equals(object.getName())) {
            String paramName = object.getAttributeValue("paramName");
            String paramValue = object.getAttributeValue("value");
            String dwParamMapElement = this.migrateToDwMapKey(paramName, object) + " : " + (this.getExpressionMigrator().isWrapped(paramValue) ? this.getExpressionMigrator().unwrap(this.getExpressionMigrator().migrateExpression(paramValue, true, object)) : "'" + paramValue + "'");
            this.setMule4MapBuilderTagText(idx, "uri-params", object.getParentElement(), HTTP_NAMESPACE, report, () -> this.getExpressionMigrator().wrap("{" + dwParamMapElement + "}"), expr -> this.getExpressionMigrator().wrap(this.getExpressionMigrator().unwrap(expr) + " ++ {" + dwParamMapElement + "}"));
            object.getParent().removeContent((Content)object);
        }
    }

    public String migrateToDwMapKey(String originalExpression, Element object) {
        return this.getExpressionMigrator().isWrapped(originalExpression) ? "(" + this.getExpressionMigrator().unwrap(this.getExpressionMigrator().migrateExpression(originalExpression, true, object)) + ")" : "'" + originalExpression + "'";
    }
}

