/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.http;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.tools.PluginsVersions;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.project.model.pom.Dependency;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SocketsConfig
extends AbstractApplicationModelMigrationStep {
    private static final String TCP_NAMESPACE = "http://www.mulesoft.org/schema/mule/tcp";
    public static final String SOCKETS_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/sockets";
    public static final Namespace SOCKETS_NAMESPACE = Namespace.getNamespace((String)"sockets", (String)"http://www.mulesoft.org/schema/mule/sockets");
    public static final String XPATH_SELECTOR = "//*[namespace-uri()='http://www.mulesoft.org/schema/mule/tcp']";

    public String getDescription() {
        return "Update Sockets config.";
    }

    public SocketsConfig() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{SOCKETS_NAMESPACE}));
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        object.setNamespace(SOCKETS_NAMESPACE);
        if ("client-socket-properties".equals(object.getName())) {
            object.setNamespace(SOCKETS_NAMESPACE);
        }
    }

    public static void addSocketsModule(ApplicationModel applicationModel) {
        applicationModel.getPomModel().ifPresent(pom -> pom.addDependency(new Dependency.DependencyBuilder().withGroupId("org.mule.connectors").withArtifactId("mule-sockets-connector").withVersion(PluginsVersions.targetVersion("mule-sockets-connector")).withClassifier("mule-plugin").build()));
        applicationModel.addNameSpace("sockets", SOCKETS_NAMESPACE_URI, "http://www.mulesoft.org/schema/mule/sockets/current/mule-sockets.xsd");
    }
}

