/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.salesforce;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.salesforce.AbstractSalesforceOperationMigrationStep;
import com.mulesoft.tools.migration.library.tools.SalesforceUtils;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class InvokeApexRestMethodOperation
extends AbstractSalesforceOperationMigrationStep
implements ExpressionMigratorAware {
    private static final String name = "invoke-apex-rest-method";

    public InvokeApexRestMethodOperation() {
        super(name);
        this.setAppliedTo(XmlDslUtils.getXPathSelector((String)"http://www.mulesoft.org/schema/mule/sfdc", (String)name, (boolean)false));
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{SalesforceUtils.MULE3_SALESFORCE_NAMESPACE}));
    }

    @Override
    public void execute(Element mule3Operation, MigrationReport report) throws RuntimeException {
        String headers;
        super.execute(mule3Operation, report);
        this.resolveAttributes(mule3Operation, this.mule4Operation);
        StringBuilder requestContents = new StringBuilder();
        String body = mule3Operation.getAttributeValue("input-ref");
        if (body != null && !body.isEmpty()) {
            String expression = this.expressionMigrator.migrateExpression(body, true, mule3Operation);
            requestContents.append("body: " + this.expressionMigrator.unwrap(expression));
        }
        if ((headers = mule3Operation.getAttributeValue("requestHeaders-ref")) != null && !headers.isEmpty()) {
            String expression = this.expressionMigrator.migrateExpression(headers, true, mule3Operation);
            if (requestContents != null && !requestContents.equals("")) {
                requestContents.append(", \n");
            }
            requestContents.append("headers: " + this.expressionMigrator.unwrap(expression));
        }
        Optional<Element> mule3QueryParams = Optional.ofNullable(mule3Operation.getChild("query-parameters", SalesforceUtils.MULE3_SALESFORCE_NAMESPACE));
        mule3QueryParams.ifPresent(queryParams -> {
            List children;
            String refHeaders = queryParams.getAttributeValue("ref");
            if (refHeaders != null) {
                String expression = this.expressionMigrator.migrateExpression(refHeaders, true, queryParams);
                if (requestContents != null && !requestContents.equals("")) {
                    requestContents.append(", \n");
                }
                requestContents.append("queryParams: " + this.expressionMigrator.unwrap(expression));
            }
            if ((children = queryParams.getChildren()).size() > 0) {
                String queryParam = children.stream().map(object -> object.getContent().stream().map(innerObject -> object.getAttributeValue("key") + ": \"" + innerObject.getValue() + "\"").collect(Collectors.joining(""))).collect(Collectors.joining(", "));
                if (requestContents != null && !requestContents.equals("")) {
                    requestContents.append(", \n");
                }
                requestContents.append("queryParams: { " + queryParam + " }");
            }
        });
        if (requestContents != null && requestContents.length() != 0) {
            Element request = new Element("request", SalesforceUtils.MULE4_SALESFORCE_NAMESPACE);
            request.setContent((Content)new CDATA("%dw 2.0 output application/json\n---\n[{\n" + requestContents.toString() + "\n}]"));
            this.mule4Operation.addContent((Content)request);
        }
        XmlDslUtils.addElementAfter((Element)this.mule4Operation, (Element)mule3Operation);
        mule3Operation.getParentElement().removeContent((Content)mule3Operation);
    }

    private void resolveAttributes(Element mule3Operation, Element mule4Operation) {
        String restMethodName = mule3Operation.getAttributeValue("restMethodName");
        if (restMethodName != null && !restMethodName.isEmpty()) {
            Integer index = restMethodName.indexOf("||");
            mule4Operation.setAttribute("className", restMethodName.substring(0, index));
            mule4Operation.setAttribute("methodName", restMethodName.substring(index + 2, restMethodName.length()));
        }
    }
}

