/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.salesforce;

import com.google.common.collect.Lists;
import com.mulesoft.tools.migration.library.mule.steps.salesforce.AbstractSalesforceSourcesMigrationStep;
import com.mulesoft.tools.migration.library.tools.SalesforceUtils;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ReplayStreamingChannelSource
extends AbstractSalesforceSourcesMigrationStep
implements ExpressionMigratorAware {
    private static String m3Name = "replay-streaming-channel";
    private static String m4Name = "replay-channel-listener";

    public ReplayStreamingChannelSource() {
        super(m3Name, m4Name);
        this.setAppliedTo(XmlDslUtils.getXPathSelector((String)"http://www.mulesoft.org/schema/mule/sfdc", (String)m3Name, (boolean)false));
        this.setNamespacesContributions(Lists.newArrayList((Object[])new Namespace[]{SalesforceUtils.MULE3_SALESFORCE_NAMESPACE}));
    }

    @Override
    public void execute(Element mule3Source, MigrationReport report) throws RuntimeException {
        super.execute(mule3Source, report);
        this.resolveAttributes(mule3Source, this.mule4Source);
        XmlDslUtils.addElementAfter((Element)this.mule4Source, (Element)mule3Source);
        mule3Source.getParentElement().removeContent((Content)mule3Source);
    }

    protected void resolveAttributes(Element mule3Source, Element mule4Source) {
        String bufferSizeInBytes;
        String autoReplay;
        String replayId;
        String replayOption;
        String streamingChannel = mule3Source.getAttributeValue("streamingChannel");
        if (streamingChannel != null && !streamingChannel.isEmpty()) {
            mule4Source.setAttribute("streamingChannel", streamingChannel);
        }
        if ((replayOption = mule3Source.getAttributeValue("replayOption")) != null && !replayOption.isEmpty()) {
            mule4Source.setAttribute("replayOption", replayOption);
        }
        if ((replayId = mule3Source.getAttributeValue("replayId")) != null && !replayId.isEmpty()) {
            mule4Source.setAttribute("replayId", replayId);
        }
        if ((autoReplay = mule3Source.getAttributeValue("autoReplay")) != null && !autoReplay.isEmpty()) {
            mule4Source.setAttribute("autoReplay", autoReplay);
        }
        if ((bufferSizeInBytes = mule3Source.getAttributeValue("bufferSizeInBytes")) != null && !bufferSizeInBytes.isEmpty()) {
            mule4Source.setAttribute("bufferSizeInBytes", bufferSizeInBytes);
        }
    }
}

