/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.security.oauth2;

import com.mulesoft.tools.migration.library.mule.steps.security.oauth2.OAuth2ProviderConfig;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.Collections;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class OAuth2ProviderCreateClient
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    public static final String XPATH_SELECTOR = "//*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/oauth2-provider' and local-name() = 'create-client']";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Migrate oauth2 provider create-client operation.";
    }

    public OAuth2ProviderCreateClient() {
        this.setAppliedTo(XPATH_SELECTOR);
        this.setNamespacesContributions(Collections.singletonList(OAuth2ProviderConfig.OAUTH2_PROVIDER_NAMESPACE));
    }

    public void execute(Element element, MigrationReport report) throws RuntimeException {
        Element scopes;
        Element authorizedGrantTypes;
        Element cfg = this.getApplicationModel().getNode("/*/*[namespace-uri() = 'http://www.mulesoft.org/schema/mule/oauth2-provider' and local-name() = 'config']");
        element.setAttribute("config-ref", cfg.getAttributeValue("name"));
        XmlDslUtils.migrateExpression((Attribute)element.getAttribute("clientId"), (ExpressionMigrator)this.getExpressionMigrator());
        XmlDslUtils.migrateExpression((Attribute)element.getAttribute("secret"), (ExpressionMigrator)this.getExpressionMigrator());
        XmlDslUtils.migrateExpression((Attribute)element.getAttribute("type"), (ExpressionMigrator)this.getExpressionMigrator());
        XmlDslUtils.migrateExpression((Attribute)element.getAttribute("principal"), (ExpressionMigrator)this.getExpressionMigrator());
        Element redirectUris = element.getChild("redirect-uris", OAuth2ProviderConfig.OAUTH2_PROVIDER_NAMESPACE);
        if (redirectUris != null) {
            Attribute redirectUrisRef = redirectUris.getAttribute("ref");
            XmlDslUtils.migrateExpression((Attribute)redirectUrisRef, (ExpressionMigrator)this.getExpressionMigrator());
            redirectUrisRef.detach();
            element.setAttribute(redirectUrisRef.setName("redirectUris"));
            redirectUris.detach();
        }
        if ((authorizedGrantTypes = element.getChild("authorized-grant-types", OAuth2ProviderConfig.OAUTH2_PROVIDER_NAMESPACE)) != null) {
            Attribute authorizedGrantTypesRef = authorizedGrantTypes.getAttribute("ref");
            XmlDslUtils.migrateExpression((Attribute)authorizedGrantTypesRef, (ExpressionMigrator)this.getExpressionMigrator());
            authorizedGrantTypesRef.detach();
            element.setAttribute(authorizedGrantTypesRef.setName("authorizedGrantTypes"));
            authorizedGrantTypes.detach();
        }
        if ((scopes = element.getChild("scopes", OAuth2ProviderConfig.OAUTH2_PROVIDER_NAMESPACE)) != null) {
            Attribute scopesRef = scopes.getAttribute("ref");
            XmlDslUtils.migrateExpression((Attribute)scopesRef, (ExpressionMigrator)this.getExpressionMigrator());
            scopesRef.detach();
            element.setAttribute(scopesRef.setName("scopes"));
            scopes.detach();
        }
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

