/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.splitter;

import com.mulesoft.tools.migration.library.mule.steps.splitter.AbstractSplitter;
import com.mulesoft.tools.migration.library.mule.steps.splitter.SplitterAggregatorUtils;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.Optional;
import org.jdom2.Element;

public class ExpressionSplitter
extends AbstractSplitter
implements ExpressionMigratorAware {
    private static final String XPATH_SELECTOR = "//*[local-name()='splitter' and namespace-uri()='http://www.mulesoft.org/schema/mule/core']";
    private static final String OLD_SPLITTER_EVALUATOR_ATTRIBUTE = "evaluator";
    private static final String OLD_SPLITTER_CUSTOM_EVALUATOR_ATTRIUBUTE = "custom-evaluator";
    private ExpressionMigrator expressionMigrator;

    public ExpressionSplitter() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }

    @Override
    public void execute(Element splitter, MigrationReport report) throws RuntimeException {
        if (!this.reportOldAttributesAndFail(splitter, report)) {
            super.execute(splitter, report);
        } else {
            this.getMatchingAggregatorElement(splitter).ifPresent(SplitterAggregatorUtils::setAggregatorAsProcessed);
        }
    }

    private boolean reportOldAttributesAndFail(Element splitter, MigrationReport report) {
        boolean shouldFail = false;
        if (splitter.getAttributeValue(OLD_SPLITTER_EVALUATOR_ATTRIBUTE) != null) {
            report.report("splitter.evaluatorAttribute", splitter, splitter, new String[0]);
            shouldFail = true;
        }
        if (splitter.getAttributeValue(OLD_SPLITTER_CUSTOM_EVALUATOR_ATTRIUBUTE) != null) {
            report.report("splitter.customEvaluatorAttribute", splitter, splitter, new String[0]);
            shouldFail = true;
        }
        return shouldFail;
    }

    @Override
    protected String getMatchingAggregatorName() {
        return "collection-aggregator";
    }

    @Override
    protected Optional<String> getForEachCollectionAttribute(Element splitterElement) {
        return Optional.of(this.getExpressionMigrator().migrateExpression(splitterElement.getAttributeValue("expression"), true, splitterElement));
    }
}

