/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.mule.steps.wsc;

import com.mulesoft.tools.migration.library.mule.steps.http.AbstractHttpConnectorMigrationStep;
import com.mulesoft.tools.migration.library.mule.steps.http.HttpOutboundEndpoint;
import com.mulesoft.tools.migration.library.mule.steps.http.HttpsOutboundEndpoint;
import com.mulesoft.tools.migration.step.AbstractApplicationModelMigrationStep;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.util.TransportsUtils;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.List;
import java.util.Optional;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class WsConsumerConfig
extends AbstractApplicationModelMigrationStep
implements ExpressionMigratorAware {
    public static final String XPATH_SELECTOR = "/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/ws' and local-name()='consumer-config']";
    private ExpressionMigrator expressionMigrator;

    public String getDescription() {
        return "Update WebService consumer config.";
    }

    public WsConsumerConfig() {
        this.setAppliedTo(XPATH_SELECTOR);
    }

    public void execute(Element object, MigrationReport report) throws RuntimeException {
        Namespace wscNamespace = Namespace.getNamespace((String)"wsc", (String)"http://www.mulesoft.org/schema/mule/wsc");
        this.getApplicationModel().addNameSpace(wscNamespace.getPrefix(), wscNamespace.getURI(), "http://www.mulesoft.org/schema/mule/wsc/current/mule-wsc.xsd");
        object.setNamespace(wscNamespace);
        object.setName("config");
        Element connection = new Element("connection", wscNamespace);
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"service");
        object.removeAttribute("service");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"port");
        object.removeAttribute("port");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"wsdlLocation");
        XmlDslUtils.migrateExpression((Attribute)connection.getAttribute("wsdlLocation"), (ExpressionMigrator)this.expressionMigrator);
        object.removeAttribute("wsdlLocation");
        XmlDslUtils.copyAttributeIfPresent((Element)object, (Element)connection, (String)"serviceAddress", (String)"address");
        XmlDslUtils.migrateExpression((Attribute)connection.getAttribute("address"), (ExpressionMigrator)this.expressionMigrator);
        object.removeAttribute("serviceAddress");
        if (object.getAttribute("useConnectorToRetrieveWsdl") != null) {
            report.report("wsc.wsdl", object, object, new String[0]);
            object.removeAttribute("useConnectorToRetrieveWsdl");
        }
        if (object.getAttribute("connectorConfig") != null) {
            connection.addContent((Content)new Element("custom-transport-configuration", wscNamespace).addContent((Content)new Element("http-transport-configuration", wscNamespace).setAttribute("requesterConfig", object.getAttributeValue("connectorConfig"))));
            object.removeAttribute("connectorConfig");
        } else if (object.getAttribute("connector-ref") != null) {
            String transportConnectorName = object.getAttributeValue("connector-ref");
            Element requestConfig = new Element("request-config", AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE).setAttribute("name", transportConnectorName);
            Element requestConnection = new Element("request-connection", AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE);
            requestConfig.addContent((Content)requestConnection);
            XmlDslUtils.addTopLevelElement((Element)requestConfig, (Document)object.getDocument());
            String address = connection.getAttributeValue("address");
            TransportsUtils.processAddress((Element)connection, (MigrationReport)report).ifPresent(a -> {
                requestConnection.setAttribute("host", this.getExpressionMigrator().migrateExpression(a.getHost(), true, object));
                if (a.getPort() != null) {
                    requestConnection.setAttribute("port", this.getExpressionMigrator().migrateExpression(a.getPort(), true, object));
                }
                requestConnection.setAttribute("protocol", "HTTP");
            });
            connection.setAttribute("address", address);
            Element connector = this.getApplicationModel().getNode("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/http' and local-name()='connector' and @name='" + transportConnectorName + "']");
            if (connector != null) {
                HttpOutboundEndpoint.handleConnector(connector, requestConnection, report, wscNamespace, this.getApplicationModel());
            } else {
                connector = this.getApplicationModel().getNode("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/https' and local-name()='connector' and @name='" + transportConnectorName + "']");
                if (connector != null) {
                    HttpOutboundEndpoint.handleConnector(connector, requestConnection, report, wscNamespace, this.getApplicationModel());
                    HttpsOutboundEndpoint.migrate(requestConnection, Optional.of(connector), report, this.getApplicationModel(), "tls-client");
                }
            }
            connection.addContent((Content)new Element("custom-transport-configuration", wscNamespace).addContent((Content)new Element("http-transport-configuration", wscNamespace).setAttribute("requesterConfig", transportConnectorName)));
            object.removeAttribute("connector-ref");
        } else {
            String address = connection.getAttributeValue("address");
            TransportsUtils.processAddress((Element)connection, (MigrationReport)report).ifPresent(a -> {
                if ("https".equals(a.getProtocol())) {
                    List connectors = this.getApplicationModel().getNodes("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/https' and local-name()='connector']");
                    if (connectors.isEmpty()) {
                        return;
                    }
                    Element connector = (Element)connectors.iterator().next();
                    Element requestConfig = new Element("request-config", AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE).setAttribute("name", connector.getAttributeValue("name"));
                    Element requestConnection = new Element("request-connection", AbstractHttpConnectorMigrationStep.HTTP_NAMESPACE);
                    requestConfig.addContent((Content)requestConnection);
                    XmlDslUtils.addTopLevelElement((Element)requestConfig, (Document)connector.getDocument());
                    requestConnection.setAttribute("host", this.getExpressionMigrator().migrateExpression(a.getHost(), true, object));
                    if (a.getPort() != null) {
                        requestConnection.setAttribute("port", this.getExpressionMigrator().migrateExpression(a.getPort(), true, object));
                    }
                    requestConnection.setAttribute("protocol", "HTTPS");
                    HttpOutboundEndpoint.handleConnector(connector, requestConnection, report, wscNamespace, this.getApplicationModel());
                    HttpsOutboundEndpoint.migrate(requestConnection, Optional.of(connector), report, this.getApplicationModel(), "tls-client");
                    connection.addContent((Content)new Element("custom-transport-configuration", wscNamespace).addContent((Content)new Element("http-transport-configuration", wscNamespace).setAttribute("requesterConfig", connector.getAttributeValue("name"))));
                    object.removeAttribute("connector-ref");
                } else if (!"jms".equals(a.getProtocol())) {
                    report.report("wsc.unsupportedProtocol", object, object, new String[0]);
                }
            });
            connection.setAttribute("address", address);
        }
        object.addContent((Content)connection);
        Namespace ws3Namespace = Namespace.getNamespace((String)"ws", (String)"http://www.mulesoft.org/schema/mule/ws");
        if (object.getChild("security", ws3Namespace) != null) {
            Element trustStore;
            Element keyStore;
            Element keyStoreConfig;
            Element tlsContext;
            String tlsContextName;
            Namespace tlsNamespace = Namespace.getNamespace((String)"tls", (String)"http://www.mulesoft.org/schema/mule/tls");
            Element security = object.getChild("security", ws3Namespace);
            security.setName("web-service-security");
            security.setNamespace(wscNamespace);
            security.detach();
            connection.addContent((Content)security);
            if (security.getChild("wss-sign", ws3Namespace) != null) {
                Element sign = security.getChild("wss-sign", ws3Namespace);
                sign.setName("sign-security-strategy");
                sign.setNamespace(wscNamespace);
                tlsContextName = sign.getAttributeValue("tlsContext-ref");
                sign.removeAttribute("tlsContext-ref");
                tlsContext = this.getApplicationModel().getNode("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/tls' and local-name()='context' and @name='" + tlsContextName + "']");
                keyStoreConfig = new Element("key-store-configuration", wscNamespace);
                keyStore = tlsContext.getChild("key-store", tlsNamespace);
                XmlDslUtils.copyAttributeIfPresent((Element)keyStore, (Element)keyStoreConfig, (String)"path", (String)"keyStorePath", (boolean)false);
                XmlDslUtils.copyAttributeIfPresent((Element)keyStore, (Element)keyStoreConfig, (String)"keyPassword", (boolean)false);
                XmlDslUtils.copyAttributeIfPresent((Element)keyStore, (Element)keyStoreConfig, (String)"password", (boolean)false);
                XmlDslUtils.copyAttributeIfPresent((Element)keyStore, (Element)keyStoreConfig, (String)"alias", (boolean)false);
                XmlDslUtils.copyAttributeIfPresent((Element)keyStore, (Element)keyStoreConfig, (String)"type", (boolean)false);
                sign.addContent((Content)keyStoreConfig);
                if (!this.getApplicationModel().getNodeOptional("//*[@tlsContext-ref='" + tlsContextName + "']").isPresent()) {
                    tlsContext.detach();
                }
                sign.detach();
                security.addContent((Content)sign);
            }
            if (security.getChild("wss-verify-signature", ws3Namespace) != null) {
                Element verifySignature = security.getChild("wss-verify-signature", ws3Namespace);
                verifySignature.setName("verify-signature-security-strategy");
                verifySignature.setNamespace(wscNamespace);
                tlsContextName = verifySignature.getAttributeValue("tlsContext-ref");
                verifySignature.removeAttribute("tlsContext-ref");
                tlsContext = this.getApplicationModel().getNode("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/tls' and local-name()='context' and @name='" + tlsContextName + "']");
                keyStoreConfig = new Element("trust-store-configuration", wscNamespace);
                trustStore = tlsContext.getChild("trust-store", tlsNamespace);
                XmlDslUtils.copyAttributeIfPresent((Element)trustStore, (Element)keyStoreConfig, (String)"path", (String)"trustStorePath", (boolean)false);
                XmlDslUtils.copyAttributeIfPresent((Element)trustStore, (Element)keyStoreConfig, (String)"password", (boolean)false);
                XmlDslUtils.copyAttributeIfPresent((Element)trustStore, (Element)keyStoreConfig, (String)"alias", (boolean)false);
                XmlDslUtils.copyAttributeIfPresent((Element)trustStore, (Element)keyStoreConfig, (String)"type", (boolean)false);
                verifySignature.addContent((Content)keyStoreConfig);
                if (!this.getApplicationModel().getNodeOptional("//*[@tlsContext-ref='" + tlsContextName + "']").isPresent()) {
                    tlsContext.detach();
                }
                verifySignature.detach();
                security.addContent((Content)verifySignature);
            }
            if (security.getChild("wss-username-token", ws3Namespace) != null) {
                Element userNameToken = security.getChild("wss-username-token", ws3Namespace);
                userNameToken.setName("username-token-security-strategy");
                userNameToken.setNamespace(wscNamespace);
                userNameToken.detach();
                security.addContent((Content)userNameToken);
            }
            if (security.getChild("wss-timestamp", ws3Namespace) != null) {
                Element timestamp = security.getChild("wss-timestamp", ws3Namespace);
                timestamp.setName("timestamp-security-strategy");
                timestamp.setNamespace(wscNamespace);
                timestamp.getAttribute("expires").setName("timeToLive");
                timestamp.detach();
                security.addContent((Content)timestamp);
            }
            if (security.getChild("wss-decrypt", ws3Namespace) != null) {
                Element decrypt = security.getChild("wss-decrypt", ws3Namespace);
                decrypt.setName("decrypt-security-strategy");
                decrypt.setNamespace(wscNamespace);
                tlsContextName = decrypt.getAttributeValue("tlsContext-ref");
                decrypt.removeAttribute("tlsContext-ref");
                tlsContext = this.getApplicationModel().getNode("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/tls' and local-name()='context' and @name='" + tlsContextName + "']");
                keyStoreConfig = new Element("key-store-configuration", wscNamespace);
                keyStore = tlsContext.getChild("key-store", tlsNamespace);
                XmlDslUtils.copyAttributeIfPresent((Element)keyStore, (Element)keyStoreConfig, (String)"path", (String)"keyStorePath", (boolean)false);
                XmlDslUtils.copyAttributeIfPresent((Element)keyStore, (Element)keyStoreConfig, (String)"keyPassword", (boolean)false);
                XmlDslUtils.copyAttributeIfPresent((Element)keyStore, (Element)keyStoreConfig, (String)"password", (boolean)false);
                XmlDslUtils.copyAttributeIfPresent((Element)keyStore, (Element)keyStoreConfig, (String)"alias", (boolean)false);
                XmlDslUtils.copyAttributeIfPresent((Element)keyStore, (Element)keyStoreConfig, (String)"type", (boolean)false);
                decrypt.addContent((Content)keyStoreConfig);
                if (decrypt.getAttribute("alias") != null) {
                    keyStoreConfig.setAttribute("alias", decrypt.getAttributeValue("alias"));
                    decrypt.removeAttribute("alias");
                }
                if (!this.getApplicationModel().getNodeOptional("//*[@tlsContext-ref='" + tlsContextName + "']").isPresent()) {
                    tlsContext.detach();
                }
                decrypt.detach();
                security.addContent((Content)decrypt);
            }
            if (security.getChild("wss-encrypt", ws3Namespace) != null) {
                Element encrypt = security.getChild("wss-encrypt", ws3Namespace);
                encrypt.setName("encrypt-security-strategy");
                encrypt.setNamespace(wscNamespace);
                tlsContextName = encrypt.getAttributeValue("tlsContext-ref");
                encrypt.removeAttribute("tlsContext-ref");
                tlsContext = this.getApplicationModel().getNode("/*/*[namespace-uri()='http://www.mulesoft.org/schema/mule/tls' and local-name()='context' and @name='" + tlsContextName + "']");
                keyStoreConfig = new Element("key-store-configuration", wscNamespace);
                trustStore = tlsContext.getChild("trust-store", tlsNamespace);
                XmlDslUtils.copyAttributeIfPresent((Element)trustStore, (Element)keyStoreConfig, (String)"path", (String)"keyStorePath", (boolean)false);
                XmlDslUtils.copyAttributeIfPresent((Element)trustStore, (Element)keyStoreConfig, (String)"password", (boolean)false);
                XmlDslUtils.copyAttributeIfPresent((Element)trustStore, (Element)keyStoreConfig, (String)"alias", (boolean)false);
                XmlDslUtils.copyAttributeIfPresent((Element)trustStore, (Element)keyStoreConfig, (String)"type", (boolean)false);
                encrypt.addContent((Content)keyStoreConfig);
                if (encrypt.getAttribute("alias") != null) {
                    keyStoreConfig.setAttribute("alias", encrypt.getAttributeValue("alias"));
                    encrypt.removeAttribute("alias");
                }
                if (!this.getApplicationModel().getNodeOptional("//*[@tlsContext-ref='" + tlsContextName + "']").isPresent()) {
                    tlsContext.detach();
                }
                encrypt.detach();
                security.addContent((Content)encrypt);
            }
        }
    }

    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

