/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.library.munit.steps;

import com.mulesoft.tools.migration.exception.MigrationStepException;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.step.category.NamespaceContribution;
import org.jdom2.Document;
import org.jdom2.Namespace;

public class MUnitNamespaces
implements NamespaceContribution {
    private static final String MUNIT_PATH = "src/test/munit";
    private static final String MUNIT_MOCK_NAME = "mock";
    private static final String MUNIT_MOCK_URI = "http://www.mulesoft.org/schema/mule/mock";
    private static final String MUNIT_MOCK_SCHEMA = "http://www.mulesoft.org/schema/mule/mock/current/mule-mock.xsd";
    private static final String MUNIT_TOOLS_NAME = "munit-tools";
    private static final String MUNIT_TOOLS_URI = "http://www.mulesoft.org/schema/mule/munit-tools";
    private static final String MUNIT_TOOLS_SCHEMA = "http://www.mulesoft.org/schema/mule/munit-tools/current/mule-munit-tools.xsd";

    public String getDescription() {
        return "Remove MUnit Mock namespace and add MUnit-Tools default namespace.";
    }

    public void execute(ApplicationModel applicationModel, MigrationReport report) throws RuntimeException {
        try {
            applicationModel.removeNameSpace(MUNIT_MOCK_NAME, MUNIT_MOCK_URI, MUNIT_MOCK_SCHEMA);
            Namespace namespace = Namespace.getNamespace((String)MUNIT_TOOLS_NAME, (String)MUNIT_TOOLS_URI);
            applicationModel.getApplicationDocuments().values().stream().filter(d -> this.isMUnitFile((Document)d)).forEach(e -> ApplicationModel.addNameSpace((Namespace)namespace, (String)MUNIT_TOOLS_SCHEMA, (Document)e));
        }
        catch (Exception e2) {
            throw new MigrationStepException("Fail to apply step. " + e2.getMessage(), (Throwable)e2);
        }
    }

    public boolean isMUnitFile(Document document) {
        return document.getBaseURI() != null && document.getBaseURI().contains(MUNIT_PATH);
    }
}

