/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.project.model;

import com.google.common.base.Preconditions;
import com.mulesoft.tools.migration.project.ProjectType;
import com.mulesoft.tools.migration.project.model.artifact.MuleArtifactJsonModel;
import com.mulesoft.tools.migration.project.model.pom.PomModel;
import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.xml.AdditionalNamespacesFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

public class ApplicationModel {
    private final Map<Path, Document> applicationDocuments;
    private final Map<Path, Document> domainDocuments;
    private ProjectType projectType;
    private String muleVersion;
    private PomModel pomModel;
    private Path sourceProjectBasePath;
    private Path projectBasePath;
    private MuleArtifactJsonModel muleArtifactJsonModel;
    private List<Namespace> supportedNamespaces;

    protected ApplicationModel(Map<Path, Document> applicationDocuments) {
        this(applicationDocuments, Collections.emptyMap());
    }

    protected ApplicationModel(Map<Path, Document> applicationDocuments, Map<Path, Document> domainDocuments) {
        this.applicationDocuments = applicationDocuments;
        this.domainDocuments = domainDocuments;
    }

    public Map<Path, Document> getApplicationDocuments() {
        return this.applicationDocuments;
    }

    public Map<Path, Document> getDomainDocuments() {
        return this.domainDocuments;
    }

    public List<Element> getNodes(String xpathExpression) {
        return this.getNodes(XPathFactory.instance().compile(xpathExpression));
    }

    public Element getNode(String xpathExpression) {
        List<Element> nodes = this.getNodes(XPathFactory.instance().compile(xpathExpression));
        if (nodes.isEmpty() || nodes.size() > 1) {
            throw new IllegalStateException(String.format("Found %d nodes for xpath expression '%s'", nodes.size(), xpathExpression));
        }
        return nodes.stream().findFirst().orElse(null);
    }

    public Optional<Element> getNodeOptional(String xpathExpression) {
        List<Element> nodes = this.getNodes(XPathFactory.instance().compile(xpathExpression));
        if (nodes.isEmpty()) {
            return Optional.empty();
        }
        if (nodes.size() > 1) {
            throw new IllegalStateException(String.format("Found %d nodes for xpath expression '%s'", nodes.size(), xpathExpression));
        }
        return Optional.of(nodes.get(0));
    }

    public List<Element> getNodes(XPathExpression xpathExpression) {
        Preconditions.checkArgument((xpathExpression != null ? 1 : 0) != 0, (Object)"The Xpath Expression must not be null nor empty");
        LinkedList<Element> nodes = new LinkedList<Element>();
        for (Document doc : this.getApplicationDocuments().values()) {
            nodes.addAll(this.getElementsFromDocument(xpathExpression, doc));
        }
        for (Document doc : this.getDomainDocuments().values()) {
            nodes.addAll(this.getElementsFromDocument(xpathExpression, doc));
        }
        return nodes;
    }

    public static List<Element> getElementsWithNamespace(Document document, Namespace namespace, ApplicationModel applicationModel) {
        String xPathExpression = "//*[namespace-uri()='" + namespace.getURI() + "']";
        XPathExpression xpath = XPathFactory.instance().compile(xPathExpression, Filters.element(), null, AdditionalNamespacesFactory.getDocumentNamespaces(document, applicationModel.getSupportedNamespaces()));
        return xpath.evaluate((Object)document);
    }

    public void addNameSpace(String prefix, String uri, String schemaLocation) {
        Namespace namespace = Namespace.getNamespace((String)prefix, (String)uri);
        for (Document doc : this.applicationDocuments.values()) {
            ApplicationModel.addNameSpace(namespace, schemaLocation, doc);
        }
        for (Document doc : this.domainDocuments.values()) {
            ApplicationModel.addNameSpace(namespace, schemaLocation, doc);
        }
    }

    public static void addNameSpace(Namespace namespace, String schemaLocation, Document document) {
        document.getRootElement().addNamespaceDeclaration(namespace);
        Attribute schemaLocationAttribute = document.getRootElement().getAttribute("schemaLocation", document.getRootElement().getNamespace("xsi"));
        if (!schemaLocationAttribute.getValue().contains(namespace.getURI() + " ") && !schemaLocationAttribute.getValue().contains(schemaLocation)) {
            StringBuilder value = new StringBuilder(schemaLocationAttribute.getValue());
            value.append(" " + namespace.getURI());
            value.append(" " + schemaLocation);
            schemaLocationAttribute.setValue(value.toString());
        }
    }

    public void removeNameSpace(String prefix, String uri, String schemaLocation) {
        Namespace namespace = Namespace.getNamespace((String)prefix, (String)uri);
        for (Document doc : this.getApplicationDocuments().values()) {
            this.removeNameSpace(namespace, schemaLocation, doc);
        }
    }

    public void removeNameSpace(Namespace namespace, String schemaLocation, Document document) {
        Element rootElement = document.getRootElement();
        rootElement.removeNamespaceDeclaration(namespace);
        Attribute schemaLocationAttribute = rootElement.getAttribute("schemaLocation", rootElement.getNamespace("xsi"));
        if (schemaLocationAttribute.getValue().contains(namespace.getURI()) && schemaLocationAttribute.getValue().contains(schemaLocation)) {
            String value = schemaLocationAttribute.getValue();
            value = value.replace(schemaLocation, "");
            value = value.replace(namespace.getURI(), "");
            schemaLocationAttribute.setValue(value);
        }
    }

    public List<Element> getElementsFromDocument(XPathExpression xpath, Document document) {
        XPathExpression compiledXPath = XPathFactory.instance().compile(xpath.getExpression(), Filters.element(), null, AdditionalNamespacesFactory.getDocumentNamespaces(document, this.supportedNamespaces));
        try {
            return compiledXPath.evaluate((Object)document);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().matches("Namespace with prefix '\\w+' has not been declared.")) {
                return Collections.emptyList();
            }
            throw e;
        }
    }

    public List<Document> getDocumentsContainString(String value) {
        ArrayList<Document> documents = new ArrayList<Document>();
        for (Document doc : this.getApplicationDocuments().values()) {
            if (!this.documentContainsString(value, doc)) continue;
            documents.add(doc);
        }
        for (Document doc : this.getDomainDocuments().values()) {
            if (!this.documentContainsString(value, doc)) continue;
            documents.add(doc);
        }
        return documents;
    }

    private boolean documentContainsString(String value, Document doc) {
        XMLOutputter outputter = new XMLOutputter();
        return outputter.outputString(doc).contains(value);
    }

    private void setPomModel(PomModel pomModel) {
        this.pomModel = pomModel;
    }

    public Optional<PomModel> getPomModel() {
        return Optional.ofNullable(this.pomModel);
    }

    public void setProjectType(ProjectType projectType) {
        this.projectType = projectType;
    }

    public ProjectType getProjectType() {
        return this.projectType;
    }

    public void setMuleVersion(String muleVersion) {
        this.muleVersion = muleVersion;
    }

    public String getMuleVersion() {
        return this.muleVersion;
    }

    private void setSourceProjectBasePath(Path sourceProjectBasePath) {
        this.sourceProjectBasePath = sourceProjectBasePath;
    }

    public Path getSourceProjectBasePath() {
        return this.sourceProjectBasePath;
    }

    private void setProjectBasePath(Path projectBasePath) {
        this.projectBasePath = projectBasePath;
    }

    public Path getProjectBasePath() {
        return this.projectBasePath;
    }

    private void setMuleArtifactJsonModel(MuleArtifactJsonModel muleArtifactJsonModel) {
        this.muleArtifactJsonModel = muleArtifactJsonModel;
    }

    public Optional<MuleArtifactJsonModel> getMuleArtifactJsonModel() {
        return Optional.ofNullable(this.muleArtifactJsonModel);
    }

    public void setSupportedNamespaces(List<Namespace> supportedNamespaces) {
        this.supportedNamespaces = supportedNamespaces;
    }

    public List<Namespace> getSupportedNamespaces() {
        return this.supportedNamespaces;
    }

    public void updateApplicationModelReference(Path fileName, Path newFileName) {
        Path relativeFilePath = this.projectBasePath.relativize(fileName);
        Path keyToRemove = this.applicationDocuments.keySet().stream().filter(key -> key.equals(relativeFilePath)).findFirst().orElse(null);
        if (keyToRemove != null) {
            Document newDocument = this.applicationDocuments.get(keyToRemove);
            newDocument.setBaseURI(newFileName.toUri().toString());
            this.applicationDocuments.put(this.projectBasePath.relativize(newFileName), newDocument);
            this.applicationDocuments.remove(keyToRemove);
        }
    }

    public static class ApplicationModelBuilder {
        private Collection<Path> configurationFiles;
        private Collection<Path> testConfigurationFiles;
        private Path muleArtifactJson;
        private Path pom;
        private Path sourceProjectBasePath;
        private Path projectBasePath;
        private Path parentDomainBasePath;
        private ProjectType projectType;
        private String muleVersion;
        private List<Namespace> supportedNamespaces;

        public ApplicationModelBuilder withConfigurationFiles(Collection<Path> configurationFiles) {
            this.configurationFiles = configurationFiles;
            return this;
        }

        public ApplicationModelBuilder withTestConfigurationFiles(Collection<Path> testConfigurationFiles) {
            this.testConfigurationFiles = testConfigurationFiles;
            return this;
        }

        public ApplicationModelBuilder withMuleArtifactJson(Path muleArtifactJson) {
            this.muleArtifactJson = muleArtifactJson;
            return this;
        }

        public ApplicationModelBuilder withPom(Path pom) {
            this.pom = pom;
            return this;
        }

        public ApplicationModelBuilder withSourceProjectBasePath(Path sourceProjectBasePath) {
            this.sourceProjectBasePath = sourceProjectBasePath;
            return this;
        }

        public ApplicationModelBuilder withProjectBasePath(Path projectBasePath) {
            this.projectBasePath = projectBasePath;
            return this;
        }

        public ApplicationModelBuilder withParentDomainBasePath(Path parentDomainBasePath) {
            this.parentDomainBasePath = parentDomainBasePath;
            return this;
        }

        public ApplicationModelBuilder withProjectType(ProjectType type) {
            this.projectType = type;
            return this;
        }

        public ApplicationModelBuilder withMuleVersion(String muleVersion) {
            this.muleVersion = muleVersion;
            return this;
        }

        public ApplicationModelBuilder withSupportedNamespaces(List<Namespace> supportedNamespaces) {
            this.supportedNamespaces = supportedNamespaces;
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ApplicationModel build() throws Exception {
            ApplicationModel applicationModel;
            Preconditions.checkArgument((this.projectBasePath != null ? 1 : 0) != 0, (Object)"Project base path cannot be null");
            HashSet<Path> applicationFilePaths = new HashSet<Path>();
            if (this.configurationFiles != null) {
                applicationFilePaths.addAll(this.configurationFiles);
            }
            if (this.testConfigurationFiles != null) {
                applicationFilePaths.addAll(this.testConfigurationFiles);
            }
            HashMap<Path, Document> applicationDocuments = new HashMap<Path, Document>();
            for (Path afp : applicationFilePaths) {
                try {
                    applicationDocuments.put(this.projectBasePath.relativize(afp), XmlDslUtils.generateDocument(afp));
                }
                catch (IOException | JDOMException e) {
                    throw new RuntimeException("Application Model Generation Error - Fail to parse file: " + afp, e);
                }
            }
            if (this.parentDomainBasePath != null) {
                HashSet<Path> domainFilePaths = new HashSet<Path>();
                Path domainSourceFilesPath = this.parentDomainBasePath.resolve("src" + File.separator + "main" + File.separator + "domain");
                if (!domainSourceFilesPath.toFile().exists()) throw new RuntimeException("Application Model Generation Error - The provided domain isn't a Mule 3 domain: " + this.parentDomainBasePath);
                for (File domainXmlFile : domainSourceFilesPath.toFile().listFiles((FilenameFilter)new SuffixFileFilter(".xml"))) {
                    domainFilePaths.add(domainXmlFile.toPath());
                }
                HashMap<Path, Document> domainDocuments = new HashMap<Path, Document>();
                for (Path dfp : domainFilePaths) {
                    try {
                        domainDocuments.put(this.parentDomainBasePath.relativize(dfp), XmlDslUtils.generateDocument(dfp));
                    }
                    catch (IOException | JDOMException e) {
                        throw new RuntimeException("Application Model Generation Error - Fail to parse file: " + dfp, e);
                    }
                }
                applicationModel = new ApplicationModel(applicationDocuments, domainDocuments);
            } else {
                applicationModel = new ApplicationModel(applicationDocuments);
            }
            if (this.muleArtifactJson != null) {
                MuleArtifactJsonModel.MuleApplicationJsonModelBuilder builder = new MuleArtifactJsonModel.MuleApplicationJsonModelBuilder();
                builder.withMuleArtifactJson(this.muleArtifactJson);
                if (!this.muleArtifactJson.toFile().exists()) {
                    builder.withMuleVersion(this.muleVersion);
                }
                applicationModel.setMuleArtifactJsonModel(builder.build());
            }
            PomModel pomModel = this.pom != null && this.pom.toFile().exists() ? new PomModel.PomModelBuilder().withPom(this.pom).build() : new PomModel.PomModelBuilder().withArtifactId(this.projectBasePath.getFileName().toString()).withPackaging(this.projectType.getPackaging()).build();
            applicationModel.setProjectType(this.projectType);
            applicationModel.setMuleVersion(this.muleVersion);
            applicationModel.setPomModel(pomModel);
            applicationModel.setSourceProjectBasePath(this.sourceProjectBasePath);
            applicationModel.setProjectBasePath(this.projectBasePath);
            applicationModel.setSupportedNamespaces((List<Namespace>)(this.supportedNamespaces != null ? new ArrayList<Namespace>(new HashSet<Namespace>(this.supportedNamespaces)) : Collections.emptyList()));
            return applicationModel;
        }
    }
}

