/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.task;

import com.google.common.base.Preconditions;
import com.mulesoft.tools.migration.exception.MigrationAbortException;
import com.mulesoft.tools.migration.exception.MigrationStepException;
import com.mulesoft.tools.migration.exception.MigrationTaskException;
import com.mulesoft.tools.migration.project.model.ApplicationModel;
import com.mulesoft.tools.migration.project.model.pom.PomModel;
import com.mulesoft.tools.migration.step.ExpressionMigratorAware;
import com.mulesoft.tools.migration.step.MigrationStep;
import com.mulesoft.tools.migration.step.category.ApplicationModelContribution;
import com.mulesoft.tools.migration.step.category.MigrationReport;
import com.mulesoft.tools.migration.task.MigrationStepSelector;
import com.mulesoft.tools.migration.task.MigrationTask;
import com.mulesoft.tools.migration.util.ExpressionMigrator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public abstract class AbstractMigrationTask
implements MigrationTask,
ExpressionMigratorAware {
    private ApplicationModel applicationModel;
    private ExpressionMigrator expressionMigrator;
    private XMLOutputter outp = new XMLOutputter();

    @Override
    public ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    @Override
    public void setApplicationModel(ApplicationModel applicationModel) {
        Preconditions.checkArgument((applicationModel != null ? 1 : 0) != 0, (Object)"The application model must not be null.");
        this.applicationModel = applicationModel;
    }

    @Override
    public void execute(MigrationReport report) throws Exception {
        Preconditions.checkState((this.applicationModel != null ? 1 : 0) != 0, (Object)"An application model must be provided.");
        List<MigrationStep> steps = this.getSteps();
        try {
            MigrationStepSelector stepSelector;
            if (steps != null && this.shouldExecuteAllSteps(stepSelector = new MigrationStepSelector(steps))) {
                steps.stream().filter(s -> s instanceof ExpressionMigratorAware).forEach(s -> ((ExpressionMigratorAware)((Object)s)).setExpressionMigrator(this.getExpressionMigrator()));
                stepSelector.getNameSpaceContributionSteps().forEach(s -> s.execute(this.applicationModel, report));
                stepSelector.getApplicationModelContributionSteps().forEach(s -> {
                    s.setApplicationModel(this.applicationModel);
                    this.fetchAndProcessNodes(report, (ApplicationModelContribution)s, (List<Element>)new ArrayList<Element>());
                });
                stepSelector.getProjectStructureContributionSteps().forEach(s -> {
                    s.setApplicationModel(this.applicationModel);
                    s.execute(this.applicationModel.getProjectBasePath(), report);
                });
                stepSelector.getPomContributionSteps().forEach(s -> {
                    s.setApplicationModel(this.applicationModel);
                    s.execute(this.applicationModel.getPomModel().orElse(new PomModel()), report);
                });
            }
        }
        catch (MigrationAbortException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MigrationTaskException("Task execution exception. " + e.getMessage(), e);
        }
    }

    private void fetchAndProcessNodes(MigrationReport report, ApplicationModelContribution s, List<Element> alreadyProcessed) {
        AtomicInteger processedElements = new AtomicInteger(0);
        List<Element> nodes = this.applicationModel.getNodes(s.getAppliedTo());
        nodes.stream().filter(n -> !alreadyProcessed.contains(n)).forEach(n -> {
            try {
                processedElements.incrementAndGet();
                s.execute(n, report);
            }
            catch (Exception e) {
                throw new MigrationStepException("Task execution exception (" + e.getMessage() + ") migrating node:" + System.lineSeparator() + this.outp.outputString(n), e);
            }
        });
        alreadyProcessed.addAll(nodes);
        nodes.removeAll(this.applicationModel.getNodes(s.getAppliedTo()));
        if (!nodes.isEmpty()) {
            this.fetchAndProcessNodes(report, s, alreadyProcessed);
        }
        report.addProcessedElements(processedElements.get());
    }

    protected boolean shouldExecuteAllSteps(MigrationStepSelector stepSelector) {
        boolean doesNothaveApplicationModelContributions = stepSelector.getApplicationModelContributionSteps().isEmpty();
        boolean isApplicable = stepSelector.getApplicationModelContributionSteps().stream().anyMatch(s -> !this.applicationModel.getNodes(s.getAppliedTo()).isEmpty());
        return isApplicable || doesNothaveApplicationModelContributions;
    }

    @Override
    public void setExpressionMigrator(ExpressionMigrator expressionMigrator) {
        this.expressionMigrator = expressionMigrator;
    }

    @Override
    public ExpressionMigrator getExpressionMigrator() {
        return this.expressionMigrator;
    }
}

