/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.tools.migration.xml;

import com.mulesoft.tools.migration.step.util.XmlDslUtils;
import com.mulesoft.tools.migration.task.AbstractMigrationTask;
import com.mulesoft.tools.migration.task.MigrationStepSelector;
import com.mulesoft.tools.migration.task.MigrationTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Document;
import org.jdom2.Namespace;

public class AdditionalNamespacesFactory {
    public static List<Namespace> getDocumentNamespaces(Document document, List<Namespace> tasksSupportedNamespaces) {
        HashMap namespaces = new HashMap();
        ArrayList<Namespace> documentNamespaces = new ArrayList<Namespace>();
        document.getRootElement().getAdditionalNamespaces().forEach(n -> {
            if (!StringUtils.isEmpty((CharSequence)n.getPrefix())) {
                namespaces.computeIfAbsent(n.getURI(), k -> n.getPrefix());
            }
        });
        if (tasksSupportedNamespaces != null) {
            tasksSupportedNamespaces.stream().filter(n -> namespaces.get(n.getURI()) == null).filter(n -> !namespaces.containsValue(n.getPrefix())).forEach(n -> namespaces.put(n.getURI(), n.getPrefix()));
        }
        documentNamespaces.addAll(namespaces.entrySet().stream().map(namespace -> Namespace.getNamespace((String)((String)namespace.getValue()), (String)((String)namespace.getKey()))).collect(Collectors.toList()));
        documentNamespaces.add(Namespace.getNamespace((String)"mule", (String)XmlDslUtils.CORE_NAMESPACE.getURI()));
        return documentNamespaces;
    }

    public static List<Namespace> getTasksDeclaredNamespaces(List<AbstractMigrationTask> migrationTasks) {
        ArrayList<Namespace> taskSupportedNamespaces = new ArrayList<Namespace>();
        for (MigrationTask task : Optional.ofNullable(migrationTasks).orElse(Collections.emptyList())) {
            MigrationStepSelector stepSelector = new MigrationStepSelector(task.getSteps());
            stepSelector.getApplicationModelContributionSteps().forEach(s -> taskSupportedNamespaces.addAll(s.getNamespacesContributions()));
        }
        taskSupportedNamespaces.add(Namespace.getNamespace((String)"mule", (String)XmlDslUtils.CORE_NAMESPACE.getURI()));
        return taskSupportedNamespaces;
    }

    public static boolean containsNamespace(Namespace ns, List<Namespace> tasksSupportedNamespaces) {
        if (tasksSupportedNamespaces != null) {
            return tasksSupportedNamespaces.stream().anyMatch(n -> StringUtils.equalsIgnoreCase((CharSequence)n.getURI(), (CharSequence)ns.getURI()));
        }
        return false;
    }
}

